/*
 * Decompiled with CFR 0.152.
 */
package com.ca.apim.gateway.cagatewayconfig.config.loader.policy;

import com.ca.apim.gateway.cagatewayconfig.beans.Policy;
import com.ca.apim.gateway.cagatewayconfig.config.loader.policy.PolicyConverter;
import com.ca.apim.gateway.cagatewayconfig.config.loader.policy.PolicyConverterException;
import com.ca.apim.gateway.cagatewayconfig.util.xml.DocumentUtils;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Optional;
import javax.inject.Singleton;
import org.apache.commons.io.IOUtils;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Element;

@Singleton
public class AssertionJSPolicyConverter
implements PolicyConverter {
    @Override
    public String getPolicyTypeExtension() {
        return ".assertion.js";
    }

    @Override
    public String getPolicyXML(Policy policy, String policyString) {
        return "<wsp:Policy xmlns:wsp=\"http://schemas.xmlsoap.org/ws/2002/12/policy\" xmlns:L7p=\"http://www.layer7tech.com/ws/policy\">\n    <wsp:All wsp:Usage=\"Required\">\n        <L7p:JavaScript>\n            <L7p:ExecutionTimeout stringValue=\"\"/>\n            <L7p:Name stringValue=\"" + policy.getName() + "\"/>\n            <L7p:Script stringValueReference=\"inline\"><![CDATA[" + policyString + "]]></L7p:Script>\n        </L7p:JavaScript>\n    </wsp:All>\n</wsp:Policy>";
    }

    @Override
    public boolean canConvert(String policyName, Element policy) {
        return this.getScriptString(policyName, policy).isPresent();
    }

    @Override
    public InputStream convertFromPolicyElement(Element policy) {
        Optional<String> jsPolicy = this.getScriptString(null, policy);
        return IOUtils.toInputStream((String)jsPolicy.orElseThrow(() -> new PolicyConverterException("Cannot Convert JS Policy")), (Charset)StandardCharsets.UTF_8);
    }

    private Optional<String> getScriptString(@Nullable String policyName, Element policy) {
        Element jsAssertion;
        Element rootAllAssertion = DocumentUtils.getSingleChildElement(policy, "wsp:All");
        if (rootAllAssertion.getChildNodes().getLength() == 1 && (jsAssertion = DocumentUtils.getSingleChildElement(rootAllAssertion, "L7p:JavaScript", true)) != null) {
            String executionTimeout = DocumentUtils.getSingleChildElementAttribute(jsAssertion, "L7p:ExecutionTimeout", "stringValue");
            String name = DocumentUtils.getSingleChildElementAttribute(jsAssertion, "L7p:Name", "stringValue");
            Element scriptElement = DocumentUtils.getSingleChildElement(jsAssertion, "L7p:Script");
            if (!(policyName != null && !policyName.equals(name) || executionTimeout != null && !executionTimeout.isEmpty() || scriptElement.getAttribute("stringValueReference").isEmpty())) {
                return Optional.of(scriptElement.getTextContent());
            }
        }
        return Optional.empty();
    }
}

