/*
 * Decompiled with CFR 0.152.
 */
package com.ca.apim.gateway.cagatewayconfig.config.loader;

import com.ca.apim.gateway.cagatewayconfig.beans.Bundle;
import com.ca.apim.gateway.cagatewayconfig.beans.EntityUtils;
import com.ca.apim.gateway.cagatewayconfig.beans.UnsupportedGatewayEntity;
import com.ca.apim.gateway.cagatewayconfig.config.loader.ConfigLoadException;
import com.ca.apim.gateway.cagatewayconfig.config.loader.EntityLoader;
import com.ca.apim.gateway.cagatewayconfig.config.loader.EntityLoaderBase;
import com.ca.apim.gateway.cagatewayconfig.util.IdGenerator;
import com.ca.apim.gateway.cagatewayconfig.util.json.JsonTools;
import com.ca.apim.gateway.cagatewayconfig.util.xml.DocumentParseException;
import com.ca.apim.gateway.cagatewayconfig.util.xml.DocumentTools;
import com.ca.apim.gateway.cagatewayconfig.util.xml.DocumentUtils;
import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jetbrains.annotations.NotNull;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@Singleton
public class UnsupportedEntityLoader
extends EntityLoaderBase<UnsupportedGatewayEntity>
implements EntityLoader {
    private static final Logger LOGGER = Logger.getLogger(UnsupportedEntityLoader.class.getName());
    private final EntityUtils.GatewayEntityInfo gatewayEntityInfo = EntityUtils.createEntityInfo(UnsupportedGatewayEntity.class);
    private final DocumentTools documentTools;

    @Inject
    public UnsupportedEntityLoader(JsonTools jsonTools, IdGenerator idGenerator, DocumentTools documentTools) {
        super(jsonTools, idGenerator);
        this.documentTools = documentTools;
    }

    @Override
    public void load(Bundle bundle, File rootDir) {
        super.load(bundle, rootDir);
        this.updateItemXml(bundle, new File(rootDir, "config"));
    }

    @Override
    public void load(Bundle bundle, String name, String value, String environmentConfigurationFolderPath) {
        super.load(bundle, name, value);
        if (environmentConfigurationFolderPath != null) {
            File configFolder = new File(environmentConfigurationFolderPath);
            this.updateItemXml(bundle, configFolder);
        }
        bundle.getUnsupportedEntities().values().stream().filter(UnsupportedGatewayEntity::isExcluded).forEach(item -> LOGGER.warning("Excluding the unsupported entity " + item.getMappingValue()));
    }

    private void updateItemXml(Bundle bundle, File configFolder) {
        File unsupportedEntityXml = new File(configFolder, "unsupported-entities.xml");
        if (unsupportedEntityXml.exists()) {
            Map<String, UnsupportedGatewayEntity> unsupportedGatewayEntityMap = bundle.getUnsupportedEntities();
            try {
                Document document = this.documentTools.parse(unsupportedEntityXml);
                List<Element> items = DocumentUtils.getChildElements(document.getDocumentElement(), "l7:Item");
                items.forEach(item -> {
                    UnsupportedGatewayEntity unsupportedGatewayEntity;
                    String itemName = DocumentUtils.getSingleChildElementTextContent(item, "l7:Name");
                    String itemType = DocumentUtils.getSingleChildElementTextContent(item, "l7:Type");
                    Element resource = DocumentUtils.getSingleChildElement(item, "l7:Resource");
                    NodeList nodeList = resource.getChildNodes();
                    Element resourceXml = null;
                    for (int index = 0; index < nodeList.getLength(); ++index) {
                        Node node = nodeList.item(index);
                        if (!(node instanceof Element)) continue;
                        resourceXml = (Element)node;
                    }
                    if (itemName != null && (unsupportedGatewayEntity = (UnsupportedGatewayEntity)unsupportedGatewayEntityMap.get(UnsupportedGatewayEntity.getMappingValue(itemType, itemName))) != null && !unsupportedGatewayEntity.isExcluded()) {
                        unsupportedGatewayEntity.setName(itemName);
                        unsupportedGatewayEntity.setElement(resourceXml);
                    }
                });
            }
            catch (DocumentParseException e) {
                throw new ConfigLoadException("Cannot load unsupported entities", e);
            }
        }
    }

    @Override
    public String getEntityType() {
        return this.gatewayEntityInfo.getType();
    }

    @Override
    protected Class<UnsupportedGatewayEntity> getBeanClass() {
        return UnsupportedGatewayEntity.class;
    }

    @Override
    protected String getFileName() {
        return this.gatewayEntityInfo.getFileName();
    }

    @Override
    protected void putToBundle(Bundle bundle, @NotNull Map<String, UnsupportedGatewayEntity> entitiesMap) {
        bundle.getUnsupportedEntities().putAll(entitiesMap);
    }
}

