/*
 * Decompiled with CFR 0.152.
 */
package com.ca.apim.gateway.cagatewayconfig.config.loader;

import com.ca.apim.gateway.cagatewayconfig.beans.Bundle;
import com.ca.apim.gateway.cagatewayconfig.beans.PropertiesEntity;
import com.ca.apim.gateway.cagatewayconfig.config.loader.ConfigLoadException;
import com.ca.apim.gateway.cagatewayconfig.config.loader.EntityLoader;
import com.ca.apim.gateway.cagatewayconfig.util.IdGenerator;
import com.ca.apim.gateway.cagatewayconfig.util.file.FileUtils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import java.util.function.BiConsumer;

public abstract class PropertiesLoaderBase<P extends PropertiesEntity>
implements EntityLoader {
    private FileUtils fileUtils;
    private final IdGenerator idGenerator;

    PropertiesLoaderBase(FileUtils fileUtils, IdGenerator idGenerator) {
        this.fileUtils = fileUtils;
        this.idGenerator = idGenerator;
    }

    @Override
    public Map<String, Object> load(File propertiesFile) {
        LinkedHashMap<String, Object> propertiesMap = new LinkedHashMap<String, Object>();
        if (propertiesFile != null && propertiesFile.exists()) {
            Properties properties = new Properties();
            try (InputStream inStream = this.fileUtils.getInputStream(propertiesFile);){
                properties.load(inStream);
            }
            catch (IOException e) {
                throw new ConfigLoadException("Could not load properties file (" + propertiesFile + "): " + e.getMessage(), e);
            }
            properties.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(k, v) -> propertiesMap.put(k.toString(), v.toString())));
        }
        return propertiesMap;
    }

    @Override
    public Object loadSingle(String name, File entitiesFile) {
        return this.load(entitiesFile).get(name);
    }

    @Override
    public void load(Bundle bundle, File rootDir) {
        File propertiesFile = FileUtils.findConfigFileOrDir(rootDir, this.getFileName());
        this.load(propertiesFile).forEach((k, v) -> this.putToBundle(bundle, rootDir, (String)k, v.toString()));
    }

    @Override
    public void load(Bundle bundle, String name, String value) {
        this.putToBundle(bundle, null, name, value);
    }

    private void putToBundle(Bundle bundle, File rootDir, String key, String value) {
        PropertiesEntity entity;
        try {
            entity = (PropertiesEntity)this.getEntityClass().getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new ConfigLoadException("Could not create entity instance for " + this.getEntityClass().getSimpleName(), e);
        }
        entity.setKey(key);
        entity.setValue(value);
        entity.postLoad(key, bundle, rootDir, this.idGenerator);
        bundle.getEntities(this.getEntityClass()).put(key, entity);
    }

    protected abstract String getFileName();

    protected abstract Class<P> getEntityClass();
}

