/*
 * Decompiled with CFR 0.152.
 */
package com.ca.apim.gateway.cagatewayconfig.config.loader;

import com.ca.apim.gateway.cagatewayconfig.beans.Bundle;
import com.ca.apim.gateway.cagatewayconfig.beans.Dependency;
import com.ca.apim.gateway.cagatewayconfig.beans.Folder;
import com.ca.apim.gateway.cagatewayconfig.beans.Policy;
import com.ca.apim.gateway.cagatewayconfig.beans.PolicyMetadata;
import com.ca.apim.gateway.cagatewayconfig.beans.PolicyType;
import com.ca.apim.gateway.cagatewayconfig.config.loader.ConfigLoadException;
import com.ca.apim.gateway.cagatewayconfig.config.loader.EntityLoader;
import com.ca.apim.gateway.cagatewayconfig.config.loader.FolderLoaderUtils;
import com.ca.apim.gateway.cagatewayconfig.config.loader.policy.PolicyConverter;
import com.ca.apim.gateway.cagatewayconfig.config.loader.policy.PolicyConverterRegistry;
import com.ca.apim.gateway.cagatewayconfig.util.IdGenerator;
import com.ca.apim.gateway.cagatewayconfig.util.file.FileUtils;
import com.ca.apim.gateway.cagatewayconfig.util.file.JsonFileUtils;
import java.io.File;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class PolicyAndFolderLoader
implements EntityLoader {
    private final PolicyConverterRegistry policyConverterRegistry;
    private final FileUtils fileUtils;
    private final IdGenerator idGenerator;
    private final JsonFileUtils jsonFileUtils;

    @Inject
    PolicyAndFolderLoader(PolicyConverterRegistry policyConverterRegistry, FileUtils fileUtils, IdGenerator idGenerator, JsonFileUtils jsonFileUtils) {
        this.policyConverterRegistry = policyConverterRegistry;
        this.fileUtils = fileUtils;
        this.idGenerator = idGenerator;
        this.jsonFileUtils = jsonFileUtils;
    }

    @Override
    public void load(Bundle bundle, File rootDir) {
        File policyRootDir = FolderLoaderUtils.getPolicyRootDir(rootDir);
        if (policyRootDir == null) {
            return;
        }
        HashMap<String, Policy> policies = new HashMap<String, Policy>();
        this.loadPolicies(policyRootDir, policyRootDir, null, policies, bundle);
        this.loadPoliciesMetadata(rootDir, policies, bundle);
        bundle.putAllPolicies(policies);
    }

    private void loadPoliciesMetadata(File rootDir, Map<String, Policy> policies, Bundle bundle) {
        Map<String, PolicyMetadata> policyMetadataMap = this.jsonFileUtils.readPoliciesConfigFile(rootDir, PolicyMetadata.class);
        HashMap<Dependency, List<Dependency>> policyDependencyMap = new HashMap<Dependency, List<Dependency>>();
        if (policyMetadataMap != null) {
            policyMetadataMap.forEach((fullPath, policyMetadata) -> {
                policyMetadata.setFullPath((String)fullPath);
                Set dependencies = Optional.ofNullable(policyMetadata.getUsedEntities()).orElse(Collections.emptySet());
                policyDependencyMap.put(new Dependency(policyMetadata.getName(), "POLICY"), new LinkedList(dependencies));
                Policy policy = (Policy)policies.get(policyMetadata.getFullPath());
                policy.setAnnotations(policyMetadata.getAnnotations());
                policy.setTag(policyMetadata.getTag());
                policy.setSubtag(policyMetadata.getSubtag());
                policy.setPolicyType(PolicyType.fromType(policyMetadata.getType()));
                policy.setUsedEntities(policyMetadata.getUsedEntities());
                policy.setHasRouting(policyMetadata.isHasRouting());
            });
        }
        bundle.setDependencyMap(policyDependencyMap);
    }

    @Override
    public void load(Bundle bundle, String name, String value) {
        throw new ConfigLoadException("Cannot load an individual policy");
    }

    @Override
    public Object loadSingle(String name, File entitiesFile) {
        throw new ConfigLoadException("Cannot load an individual policy");
    }

    @Override
    public Map<String, Object> load(File entitiesFile) {
        throw new ConfigLoadException("Cannot load policies from config file");
    }

    private void loadPolicies(File currentDir, File rootDir, Folder parentFolder, Map<String, Policy> policies, Bundle bundle) {
        Folder folder = bundle.getFolders().computeIfAbsent(FolderLoaderUtils.getPath(currentDir, rootDir), key -> FolderLoaderUtils.createFolder(currentDir.getName(), key, parentFolder));
        File[] children = currentDir.listFiles();
        if (children != null) {
            for (File child : children) {
                Policy policy;
                Policy existingPolicy;
                if (child.isDirectory()) {
                    this.loadPolicies(child, rootDir, folder, policies, bundle);
                    continue;
                }
                if (!this.policyConverterRegistry.isValidPolicyExtension(child.getName()) || (existingPolicy = policies.put((policy = this.loadPolicy(child, rootDir, folder, bundle)).getPath(), policy)) == null) continue;
                throw new ConfigLoadException("Found multiple policies with same path but different types. Policy Path: " + policy.getPath());
            }
        }
    }

    private Policy loadPolicy(File policyFile, File rootDir, Folder parentFolder, Bundle bundle) {
        PolicyConverter policyConverter = this.policyConverterRegistry.getConverterFromFileName(policyFile.getName());
        Policy policy = new Policy();
        policy.setPath(policyConverter.removeExtension(FolderLoaderUtils.getPath(policyFile, rootDir)));
        policy.setName(policyConverter.removeExtension(policyFile.getName()));
        policy.setParentFolder(parentFolder);
        policy.setGuid(this.idGenerator.generateGuid());
        policy.setId(this.idGenerator.generate());
        policy.setPolicyXML(policyConverter.getPolicyXML(policy, this.fileUtils.getFileAsString(policyFile)));
        policy.postLoad(policy.getPath(), bundle, rootDir, this.idGenerator);
        return policy;
    }

    @Override
    public String getEntityType() {
        return "POLICY";
    }
}

