/*
 * Decompiled with CFR 0.152.
 */
package com.ca.apim.gateway.cagatewayconfig.config.loader;

import com.ca.apim.gateway.cagatewayconfig.beans.EntityTypeRegistry;
import com.ca.apim.gateway.cagatewayconfig.beans.EntityUtils;
import com.ca.apim.gateway.cagatewayconfig.config.loader.EntityLoader;
import com.ca.apim.gateway.cagatewayconfig.config.loader.EntityLoaderUtils;
import com.ca.apim.gateway.cagatewayconfig.config.spec.ConfigurationFile;
import com.ca.apim.gateway.cagatewayconfig.util.IdGenerator;
import com.ca.apim.gateway.cagatewayconfig.util.file.FileUtils;
import com.ca.apim.gateway.cagatewayconfig.util.json.JsonTools;
import com.google.common.annotations.VisibleForTesting;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jetbrains.annotations.NotNull;

@Singleton
public class EntityLoaderRegistry {
    private final Map<String, EntityLoader> entityLoaders;

    @Inject
    EntityLoaderRegistry(Set<EntityLoader> loaders, EntityTypeRegistry entityTypeRegistry, JsonTools jsonTools, IdGenerator idGenerator, FileUtils fileUtils) {
        HashMap allLoaders = new HashMap();
        loaders.forEach(l -> allLoaders.put(l.getEntityType(), l));
        entityTypeRegistry.getEntityTypeMap().values().forEach(e -> {
            if (e.getEnvironmentType() != null) {
                allLoaders.computeIfAbsent(e.getEnvironmentType(), s -> EntityLoaderRegistry.createGenericLoaderForEntity(jsonTools, idGenerator, fileUtils, e));
            }
        });
        this.entityLoaders = Collections.unmodifiableMap(allLoaders);
    }

    public EntityLoader getLoader(String type) {
        return this.entityLoaders.get(type);
    }

    public Collection<EntityLoader> getEntityLoaders() {
        return this.entityLoaders.values();
    }

    @NotNull
    @VisibleForTesting
    static EntityLoader createGenericLoaderForEntity(JsonTools jsonTools, IdGenerator idGenerator, FileUtils fileUtils, EntityUtils.GatewayEntityInfo entityInfo) {
        if (entityInfo.getFileType() == ConfigurationFile.FileType.PROPERTIES) {
            return EntityLoaderUtils.createPropertiesLoader(fileUtils, idGenerator, entityInfo);
        }
        return EntityLoaderUtils.createEntityLoader(jsonTools, idGenerator, entityInfo);
    }
}

