/*
 * Decompiled with CFR 0.152.
 */
package com.ca.apim.gateway.cagatewayconfig.config.loader;

import com.ca.apim.gateway.cagatewayconfig.beans.Bundle;
import com.ca.apim.gateway.cagatewayconfig.beans.GatewayEntity;
import com.ca.apim.gateway.cagatewayconfig.config.loader.EntityLoader;
import com.ca.apim.gateway.cagatewayconfig.config.loader.EntityLoaderUtils;
import com.ca.apim.gateway.cagatewayconfig.util.IdGenerator;
import com.ca.apim.gateway.cagatewayconfig.util.environment.EnvironmentConfigurationUtils;
import com.ca.apim.gateway.cagatewayconfig.util.json.JsonTools;
import com.fasterxml.jackson.databind.JavaType;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableMap;
import java.io.File;
import java.nio.charset.Charset;
import java.util.Map;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;

public abstract class EntityLoaderBase<B extends GatewayEntity>
implements EntityLoader {
    private final JsonTools jsonTools;
    private IdGenerator idGenerator;

    @VisibleForTesting
    protected EntityLoaderBase(JsonTools jsonTools, IdGenerator idGenerator) {
        this.jsonTools = jsonTools;
        this.idGenerator = idGenerator;
    }

    @Override
    public Object loadSingle(String name, File entitiesFile) {
        return this.load(entitiesFile).get(name);
    }

    @Override
    public Map<String, Object> load(File entitiesFile) {
        return EntityLoaderUtils.loadEntitiesFromFile(this.jsonTools, this.getBeanClass(), entitiesFile);
    }

    @Override
    public void load(Bundle bundle, File rootDir) {
        File entitiesFile = this.jsonTools.getDocumentFile(rootDir, this.getFileName());
        if (entitiesFile == null) {
            return;
        }
        Map entities = EntityLoaderUtils.loadEntitiesFromFile(this.jsonTools, this.getBeanClass(), entitiesFile);
        if (entities != null) {
            entities.forEach((k, e) -> e.postLoad((String)k, bundle, rootDir, this.idGenerator));
            this.putToBundle(bundle, entities);
        }
    }

    @Override
    public void load(Bundle bundle, String fullName, String value) {
        String name = fullName;
        String extension = FilenameUtils.getExtension((String)fullName);
        String valueType = null;
        if (StringUtils.isNotBlank((CharSequence)extension) && (valueType = this.jsonTools.getTypeFromExtension(extension)) != null) {
            name = FilenameUtils.getBaseName((String)fullName);
        }
        if (valueType == null) {
            valueType = EnvironmentConfigurationUtils.tryInferContentTypeFromValue(value);
        }
        if (valueType == null) {
            valueType = this.getDefaultValueType();
        }
        JavaType type = this.jsonTools.getObjectMapper(valueType).getTypeFactory().constructType(this.getBeanClass());
        GatewayEntity entity = (GatewayEntity)this.jsonTools.readStream(IOUtils.toInputStream((String)value, (Charset)Charset.defaultCharset()), valueType, type);
        entity.postLoad(name, bundle, null, this.idGenerator);
        this.putToBundle(bundle, (Map<String, B>)ImmutableMap.builder().put((Object)name, (Object)entity).build());
    }

    protected String getDefaultValueType() {
        return "json";
    }

    protected abstract Class<B> getBeanClass();

    protected abstract String getFileName();

    protected abstract void putToBundle(Bundle var1, @NotNull Map<String, B> var2);
}

