/*
 * Decompiled with CFR 0.152.
 */
package com.ca.apim.gateway.cagatewayconfig.bundle.loader;

import com.ca.apim.gateway.cagatewayconfig.beans.Annotation;
import com.ca.apim.gateway.cagatewayconfig.beans.Bundle;
import com.ca.apim.gateway.cagatewayconfig.beans.SsgActiveConnector;
import com.ca.apim.gateway.cagatewayconfig.bundle.loader.BundleEntityLoader;
import com.ca.apim.gateway.cagatewayconfig.util.gateway.BuilderUtils;
import com.ca.apim.gateway.cagatewayconfig.util.xml.DocumentUtils;
import com.google.common.annotations.VisibleForTesting;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import javax.inject.Singleton;
import org.w3c.dom.Element;

@Singleton
public class SsgActiveConnectorLoader
implements BundleEntityLoader {
    @VisibleForTesting
    public SsgActiveConnectorLoader() {
    }

    @Override
    public void load(Bundle bundle, Element element) {
        Element activeConnectorElement = DocumentUtils.getSingleChildElement(DocumentUtils.getSingleChildElement(element, "l7:Resource"), "l7:ActiveConnector");
        String name = DocumentUtils.getSingleChildElementTextContent(activeConnectorElement, "l7:Name");
        String type = DocumentUtils.getSingleChildElementTextContent(activeConnectorElement, "l7:Type");
        String targetServiceReference = DocumentUtils.getSingleChildElementTextContent(activeConnectorElement, "l7:HardwiredId");
        Map<String, Object> properties = BuilderUtils.mapPropertiesElements(DocumentUtils.getSingleChildElement(activeConnectorElement, "l7:Properties", true), "l7:Properties");
        SsgActiveConnector ssgActiveConnector = new SsgActiveConnector();
        ssgActiveConnector.setName(name);
        ssgActiveConnector.setConnectorType(type);
        ssgActiveConnector.setProperties(properties);
        ssgActiveConnector.setTargetServiceReference(targetServiceReference);
        ssgActiveConnector.setId(activeConnectorElement.getAttribute("id"));
        HashSet<Annotation> annotations = new HashSet<Annotation>();
        Annotation bundleEntity = new Annotation("@bundle-hints");
        bundleEntity.setId(activeConnectorElement.getAttribute("id"));
        annotations.add(bundleEntity);
        ssgActiveConnector.setAnnotations(annotations);
        Optional<Map.Entry> entryOptional = properties.entrySet().stream().filter(entry -> ((String)entry.getKey()).endsWith("SslKeystoreId")).findFirst();
        entryOptional.ifPresent(entry -> properties.remove(entry.getKey()));
        bundle.getSsgActiveConnectors().put(name, ssgActiveConnector);
    }

    @Override
    public String getEntityType() {
        return "SSG_ACTIVE_CONNECTOR";
    }
}

