/*
 * Decompiled with CFR 0.152.
 */
package com.ca.apim.gateway.cagatewayconfig.bundle.loader;

import com.ca.apim.gateway.cagatewayconfig.beans.Bundle;
import com.ca.apim.gateway.cagatewayconfig.beans.Folder;
import com.ca.apim.gateway.cagatewayconfig.beans.Service;
import com.ca.apim.gateway.cagatewayconfig.beans.SoapResource;
import com.ca.apim.gateway.cagatewayconfig.bundle.loader.BundleEntityLoader;
import com.ca.apim.gateway.cagatewayconfig.bundle.loader.BundleLoadException;
import com.ca.apim.gateway.cagatewayconfig.bundle.loader.ServiceAndPolicyLoaderUtil;
import com.ca.apim.gateway.cagatewayconfig.util.gateway.BuilderUtils;
import com.ca.apim.gateway.cagatewayconfig.util.string.CharacterBlacklistUtil;
import com.ca.apim.gateway.cagatewayconfig.util.xml.DocumentUtils;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.inject.Singleton;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@Singleton
public class ServiceLoader
implements BundleEntityLoader {
    @Override
    public void load(Bundle bundle, Element element) {
        Element urlPatternElement;
        Element service = DocumentUtils.getSingleChildElement(DocumentUtils.getSingleChildElement(element, "l7:Resource"), "l7:Service");
        Element serviceDetails = DocumentUtils.getSingleChildElement(service, "l7:ServiceDetail");
        String id = serviceDetails.getAttribute("id");
        String folderId = serviceDetails.getAttribute("folderId");
        Element nameElement = DocumentUtils.getSingleChildElement(serviceDetails, "l7:Name");
        String name = CharacterBlacklistUtil.filterAndReplace(nameElement.getTextContent());
        Element servicePropertiesElement = DocumentUtils.getSingleChildElement(serviceDetails, "l7:Properties");
        Map<String, Object> allProperties = BuilderUtils.mapPropertiesElements(servicePropertiesElement, "l7:Properties");
        HashMap<String, Object> properties = new HashMap<String, Object>();
        Service serviceEntity = new Service();
        Folder parentFolder = ServiceAndPolicyLoaderUtil.getFolder(bundle, folderId);
        serviceEntity.setName(name);
        serviceEntity.setId(id);
        serviceEntity.setPath(ServiceAndPolicyLoaderUtil.getPath(parentFolder, name));
        serviceEntity.setParentFolder(parentFolder);
        serviceEntity.setServiceDetailsElement(serviceDetails);
        this.populateServiceEntity(service, serviceEntity, allProperties, properties);
        boolean isSoapService = StringUtils.isNotBlank((CharSequence)serviceEntity.getSoapVersion());
        Element serviceMappingsElement = DocumentUtils.getSingleChildElement(serviceEntity.getServiceDetailsElement(), "l7:ServiceMappings");
        Element httpMappingElement = DocumentUtils.getSingleChildElement(serviceMappingsElement, "l7:HttpMapping");
        if (isSoapService) {
            try {
                urlPatternElement = DocumentUtils.getSingleChildElement(httpMappingElement, "l7:UrlPattern");
                serviceEntity.setUrl(urlPatternElement.getTextContent());
            }
            catch (BundleLoadException urlPatternElement2) {}
        } else {
            urlPatternElement = DocumentUtils.getSingleChildElement(httpMappingElement, "l7:UrlPattern");
            serviceEntity.setUrl(urlPatternElement.getTextContent());
        }
        Element verbsElement = DocumentUtils.getSingleChildElement(httpMappingElement, "l7:Verbs");
        NodeList verbs = verbsElement.getElementsByTagName("l7:Verb");
        HashSet<String> httpMethods = new HashSet<String>();
        for (Node verb : DocumentUtils.nodeList(verbs)) {
            httpMethods.add(verb.getTextContent());
        }
        serviceEntity.setHttpMethods(httpMethods);
        serviceEntity.setProperties(properties);
        Map<String, Service> bundleService = bundle.getServices();
        if (bundleService.containsKey(serviceEntity.getPath())) {
            String duplicatePathName = ServiceAndPolicyLoaderUtil.handleDuplicatePathName(bundleService, serviceEntity);
            serviceEntity.setName(duplicatePathName.substring(duplicatePathName.lastIndexOf(47) + 1));
            serviceEntity.setPath(duplicatePathName);
        }
        bundleService.put(serviceEntity.getPath(), serviceEntity);
    }

    private void populateServiceEntity(Element service, Service serviceEntity, Map<String, Object> allProperties, Map<String, Object> properties) {
        boolean isSoapService = false;
        String soapVersion = null;
        boolean wssProcessingEnabled = false;
        for (Map.Entry<String, Object> entry : allProperties.entrySet()) {
            if (entry.getKey().startsWith("property.")) {
                Object propertyValue = null;
                if (!entry.getKey().startsWith("property.ENV.")) {
                    propertyValue = entry.getValue();
                }
                properties.put(entry.getKey().substring(9), propertyValue);
                continue;
            }
            switch (entry.getKey()) {
                case "soap": {
                    isSoapService = Boolean.valueOf(entry.getValue().toString());
                    break;
                }
                case "soapVersion": {
                    soapVersion = entry.getValue().toString();
                    break;
                }
                case "wssProcessingEnabled": {
                    wssProcessingEnabled = Boolean.valueOf(entry.getValue().toString());
                    break;
                }
            }
        }
        Element resources = DocumentUtils.getSingleChildElement(service, "l7:Resources");
        if (isSoapService) {
            this.extractResourceSetsForSoap(resources, serviceEntity);
            serviceEntity.setWssProcessingEnabled(wssProcessingEnabled);
            serviceEntity.setSoapVersion(soapVersion);
        } else {
            Element resourceSet = DocumentUtils.getSingleChildElement(resources, "l7:ResourceSet");
            Element resource = DocumentUtils.getSingleChildElement(resourceSet, "l7:Resource");
            serviceEntity.setPolicy(resource.getTextContent());
        }
        boolean hasRouting = false;
        if (allProperties.get("hasRouting") != null) {
            hasRouting = BooleanUtils.toBoolean((String)allProperties.get("hasRouting").toString());
        }
        serviceEntity.setHasRouting(hasRouting);
    }

    private void extractResourceSetsForSoap(Element resources, Service serviceEntity) {
        List<Element> resourceSets = DocumentUtils.getChildElements(resources, "l7:ResourceSet");
        resourceSets.forEach(resourceSet -> {
            String tagValue = resourceSet.getAttribute("tag");
            if (StringUtils.isEmpty((CharSequence)tagValue)) {
                throw new BundleLoadException("No tag attribute found under l7:ResourceSet for service " + serviceEntity.getName());
            }
            List<Element> resourceElements = DocumentUtils.getChildElements(resourceSet, "l7:Resource");
            if (resourceElements.isEmpty()) {
                throw new BundleLoadException("No l7:resource elements for service " + serviceEntity.getName());
            }
            if ("wsdl".equals(tagValue)) {
                serviceEntity.setWsdlRootUrl(resourceSet.getAttribute("rootUrl"));
                resourceElements.forEach(e -> this.addServiceResource((Element)e, serviceEntity));
                return;
            }
            if (resourceElements.size() > 1) {
                throw new BundleLoadException("Multiple l7:resource elements found for service " + serviceEntity.getName());
            }
            if ("policy".equals(tagValue)) {
                Element resource = resourceElements.get(0);
                serviceEntity.setPolicy(resource.getTextContent());
            }
        });
    }

    private void addServiceResource(Element resource, Service service) {
        String rootUrl = resource.getAttribute("sourceUrl");
        String content = resource.getTextContent();
        String type = resource.getAttribute("type");
        if (StringUtils.isEmpty((CharSequence)content) && StringUtils.isEmpty((CharSequence)rootUrl)) {
            throw new BundleLoadException("No content and sourceUrl found under l7:Resource for service " + service.getName());
        }
        SoapResource soapResource = new SoapResource();
        soapResource.setRootUrl(rootUrl);
        soapResource.setContent(content);
        soapResource.setType(type);
        service.addSoapResource(soapResource);
    }

    @Override
    public String getEntityType() {
        return "SERVICE";
    }
}

