/*
 * Decompiled with CFR 0.152.
 */
package com.ca.apim.gateway.cagatewayconfig.bundle.loader;

import com.ca.apim.gateway.cagatewayconfig.beans.Annotation;
import com.ca.apim.gateway.cagatewayconfig.beans.Bundle;
import com.ca.apim.gateway.cagatewayconfig.beans.JdbcConnection;
import com.ca.apim.gateway.cagatewayconfig.bundle.loader.BundleEntityLoader;
import com.ca.apim.gateway.cagatewayconfig.util.gateway.BuilderUtils;
import com.ca.apim.gateway.cagatewayconfig.util.xml.DocumentUtils;
import com.google.common.annotations.VisibleForTesting;
import java.util.HashSet;
import java.util.Map;
import javax.inject.Singleton;
import org.w3c.dom.Element;

@Singleton
public class JdbcConnectionLoader
implements BundleEntityLoader {
    @VisibleForTesting
    public JdbcConnectionLoader() {
    }

    @Override
    public void load(Bundle bundle, Element element) {
        Element jdbcConnectionElement = DocumentUtils.getSingleChildElement(DocumentUtils.getSingleChildElement(element, "l7:Resource"), "l7:JDBCConnection");
        String name = DocumentUtils.getSingleChildElementTextContent(jdbcConnectionElement, "l7:Name");
        Map<String, Object> properties = BuilderUtils.mapPropertiesElements(DocumentUtils.getSingleChildElement(jdbcConnectionElement, "l7:Properties", true), "l7:Properties");
        Integer minPoolSize = (Integer)properties.remove("minimumPoolSize");
        Integer maxPoolSize = (Integer)properties.remove("maximumPoolSize");
        Element extension = DocumentUtils.getSingleChildElement(jdbcConnectionElement, "l7:Extension");
        String driverClass = DocumentUtils.getSingleChildElementTextContent(extension, "l7:DriverClass");
        String jdbcUrl = DocumentUtils.getSingleChildElementTextContent(extension, "l7:JdbcUrl");
        Map<String, Object> connectionProperties = BuilderUtils.mapPropertiesElements(DocumentUtils.getSingleChildElement(extension, "l7:ConnectionProperties", true), "l7:ConnectionProperties");
        String user = (String)connectionProperties.remove("user");
        String password = (String)connectionProperties.remove("password");
        JdbcConnection jdbcConnection = new JdbcConnection();
        jdbcConnection.setName(name);
        jdbcConnection.setId(jdbcConnectionElement.getAttribute("id"));
        jdbcConnection.setJdbcUrl(jdbcUrl);
        jdbcConnection.setDriverClass(driverClass);
        jdbcConnection.setUser(user);
        jdbcConnection.setPassword(password);
        jdbcConnection.setMinimumPoolSize(minPoolSize);
        jdbcConnection.setMaximumPoolSize(maxPoolSize);
        jdbcConnection.setProperties(connectionProperties);
        HashSet<Annotation> annotations = new HashSet<Annotation>();
        Annotation bundleEntity = new Annotation("@bundle-hints");
        bundleEntity.setId(jdbcConnectionElement.getAttribute("id"));
        annotations.add(bundleEntity);
        jdbcConnection.setAnnotations(annotations);
        bundle.getJdbcConnections().put(name, jdbcConnection);
    }

    @Override
    public String getEntityType() {
        return "JDBC_CONNECTION";
    }
}

