/*
 * Decompiled with CFR 0.152.
 */
package com.ca.apim.gateway.cagatewayconfig.bundle.loader;

import com.ca.apim.gateway.cagatewayconfig.beans.Annotation;
import com.ca.apim.gateway.cagatewayconfig.beans.Bundle;
import com.ca.apim.gateway.cagatewayconfig.beans.GenericEntity;
import com.ca.apim.gateway.cagatewayconfig.bundle.loader.BundleEntityLoader;
import com.ca.apim.gateway.cagatewayconfig.util.xml.DocumentUtils;
import java.util.HashSet;
import javax.inject.Singleton;
import org.w3c.dom.Element;

@Singleton
public class GenericEntityLoader
implements BundleEntityLoader {
    @Override
    public void load(Bundle bundle, Element element) {
        Element genericEntityEle = DocumentUtils.getSingleChildElement(DocumentUtils.getSingleChildElement(element, "l7:Resource"), "l7:GenericEntity");
        String name = DocumentUtils.getSingleChildElementTextContent(genericEntityEle, "l7:Name");
        String description = DocumentUtils.getSingleChildElementTextContent(genericEntityEle, "l7:Description");
        String entityClassName = DocumentUtils.getSingleChildElementTextContent(genericEntityEle, "l7:EntityClassName");
        String valueXml = DocumentUtils.getSingleChildElementTextContent(genericEntityEle, "l7:ValueXml");
        GenericEntity genericEntity = new GenericEntity();
        genericEntity.setId(genericEntityEle.getAttribute("id"));
        genericEntity.setName(name);
        genericEntity.setDescription(description);
        genericEntity.setEntityClassName(entityClassName);
        genericEntity.setValueXml(valueXml);
        HashSet<Annotation> annotations = new HashSet<Annotation>();
        Annotation bundleEntity = new Annotation("@bundle-hints");
        bundleEntity.setId(genericEntityEle.getAttribute("id"));
        annotations.add(bundleEntity);
        genericEntity.setAnnotations(annotations);
        bundle.getGenericEntities().put(name, genericEntity);
    }

    @Override
    public String getEntityType() {
        return "GENERIC";
    }
}

