/*
 * Decompiled with CFR 0.152.
 */
package com.ca.apim.gateway.cagatewayconfig.bundle.builder;

import com.ca.apim.gateway.cagatewayconfig.bundle.builder.EntityBuilderException;
import com.ca.apim.gateway.cagatewayconfig.bundle.builder.PolicyAssertionBuilder;
import com.ca.apim.gateway.cagatewayconfig.bundle.builder.PolicyBuilderContext;
import com.ca.apim.gateway.cagatewayconfig.util.gateway.BuilderUtils;
import com.ca.apim.gateway.cagatewayconfig.util.xml.DocumentParseException;
import com.ca.apim.gateway.cagatewayconfig.util.xml.DocumentUtils;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SetVariableAssertionBuilder
implements PolicyAssertionBuilder {
    private static final Logger LOGGER = Logger.getLogger(SetVariableAssertionBuilder.class.getName());
    static final String ENV_PARAM_NAME = "ENV_PARAM_NAME";

    @Override
    public void buildAssertionElement(Element assertionElement, PolicyBuilderContext policyBuilderContext) throws DocumentParseException {
        Element nameElement;
        Document policyDocument = policyBuilderContext.getPolicyDocument();
        try {
            nameElement = DocumentUtils.getSingleElement(assertionElement, "L7p:VariableToSet");
        }
        catch (DocumentParseException e) {
            throw new EntityBuilderException("Could not find VariableToSet element in a SetVariable Assertion.");
        }
        String variableName = nameElement.getAttribute("stringValue");
        if (variableName.startsWith("ENV.")) {
            assertionElement.insertBefore(DocumentUtils.createElementWithAttribute(policyDocument, "L7p:Base64Expression", ENV_PARAM_NAME, BuilderUtils.insertPrefixToEnvironmentVariable(variableName, policyBuilderContext.getPolicyName())), assertionElement.getFirstChild());
        } else {
            try {
                PolicyAssertionBuilder.prepareBase64Element(policyDocument, assertionElement, "L7p:Expression", "L7p:Base64Expression");
            }
            catch (EntityBuilderException e) {
                LOGGER.log(Level.WARNING, "Exception " + e.getMessage());
            }
        }
    }

    @Override
    public String getAssertionTagName() {
        return "L7p:SetVariable";
    }
}

