/*
 * Decompiled with CFR 0.152.
 */
package com.ca.apim.gateway.cagatewayconfig.bundle.builder;

import com.ca.apim.gateway.cagatewayconfig.beans.Bundle;
import com.ca.apim.gateway.cagatewayconfig.beans.Policy;
import com.ca.apim.gateway.cagatewayconfig.beans.ScheduledTask;
import com.ca.apim.gateway.cagatewayconfig.bundle.builder.AnnotatedBundle;
import com.ca.apim.gateway.cagatewayconfig.bundle.builder.Entity;
import com.ca.apim.gateway.cagatewayconfig.bundle.builder.EntityBuilder;
import com.ca.apim.gateway.cagatewayconfig.bundle.builder.EntityBuilderException;
import com.ca.apim.gateway.cagatewayconfig.bundle.builder.EntityBuilderHelper;
import com.ca.apim.gateway.cagatewayconfig.util.IdGenerator;
import com.ca.apim.gateway.cagatewayconfig.util.gateway.BuilderUtils;
import com.ca.apim.gateway.cagatewayconfig.util.xml.DocumentUtils;
import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jetbrains.annotations.NotNull;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

@Singleton
public class ScheduledTaskEntityBuilder
implements EntityBuilder {
    private static final Integer ORDER = 1400;
    private final IdGenerator idGenerator;

    @Inject
    ScheduledTaskEntityBuilder(IdGenerator idGenerator) {
        this.idGenerator = idGenerator;
    }

    @Override
    public List<Entity> build(Bundle bundle, EntityBuilder.BundleType bundleType, Document document) {
        if (bundle instanceof AnnotatedBundle) {
            Map scheduledTaskMap = Optional.ofNullable(bundle.getScheduledTasks()).orElse(Collections.emptyMap());
            return this.buildEntities(scheduledTaskMap, ((AnnotatedBundle)bundle).getFullBundle(), bundleType, document);
        }
        return this.buildEntities(bundle.getScheduledTasks(), bundle, bundleType, document);
    }

    private List<Entity> buildEntities(Map<String, ?> entities, Bundle bundle, EntityBuilder.BundleType bundleType, Document document) {
        if (bundleType == EntityBuilder.BundleType.ENVIRONMENT) {
            return Collections.emptyList();
        }
        return entities.entrySet().stream().map(scheduledTaskEntry -> this.buildScheduledTaskEntity(bundle, (String)scheduledTaskEntry.getKey(), (ScheduledTask)scheduledTaskEntry.getValue(), document)).collect(Collectors.toList());
    }

    private Entity buildScheduledTaskEntity(Bundle bundle, String name, ScheduledTask scheduledTask, Document document) {
        Policy policy = bundle.getPolicies().get(scheduledTask.getPolicy());
        if (policy == null) {
            throw new EntityBuilderException("Could not find policy for encass. Policy Path: " + scheduledTask.getPolicy());
        }
        String id = this.idGenerator.generate();
        Element schedTaskElement = DocumentUtils.createElementWithAttributesAndChildren(document, "l7:ScheduledTask", (Map<String, String>)ImmutableMap.of((Object)"id", (Object)id), DocumentUtils.createElementWithTextContent(document, "l7:Name", name), DocumentUtils.createElementWithAttribute(document, "l7:PolicyReference", "id", policy.getId()), DocumentUtils.createElementWithTextContent(document, "l7:OneNode", scheduledTask.getIsOneNode()), DocumentUtils.createElementWithTextContent(document, "l7:JobType", scheduledTask.getJobType()), DocumentUtils.createElementWithTextContent(document, "l7:JobStatus", scheduledTask.getJobStatus()), scheduledTask.getJobType().equals("One time") ? DocumentUtils.createElementWithTextContent(document, "l7:ExecutionDate", scheduledTask.getExecutionDate()) : DocumentUtils.createElementWithTextContent(document, "l7:CronExpression", scheduledTask.getCronExpression()), DocumentUtils.createElementWithTextContent(document, "l7:ExecuteOnCreate", scheduledTask.getShouldExecuteOnCreate()));
        if (scheduledTask.getProperties() != null) {
            BuilderUtils.buildAndAppendPropertiesElement(scheduledTask.getProperties(), document, schedTaskElement);
        }
        return EntityBuilderHelper.getEntityWithNameMapping("SCHEDULED_TASK", name, id, schedTaskElement);
    }

    @Override
    @NotNull
    public Integer getOrder() {
        return ORDER;
    }
}

