/*
 * Decompiled with CFR 0.152.
 */
package com.ca.apim.gateway.cagatewayconfig.bundle.builder;

import com.ca.apim.gateway.cagatewayconfig.bundle.builder.EntityBuilderException;
import com.ca.apim.gateway.cagatewayconfig.bundle.builder.PolicyAssertionBuilder;
import com.ca.apim.gateway.cagatewayconfig.bundle.builder.PolicyBuilderContext;
import com.ca.apim.gateway.cagatewayconfig.util.xml.DocumentParseException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@Singleton
public class PolicyXMLBuilder {
    private Map<String, PolicyAssertionBuilder> buildersByTag = new HashMap<String, PolicyAssertionBuilder>();

    @Inject
    public PolicyXMLBuilder(Set<PolicyAssertionBuilder> policyAssertionBuilders) {
        policyAssertionBuilders.forEach(s -> this.buildersByTag.put(s.getAssertionTagName(), (PolicyAssertionBuilder)s));
        this.buildersByTag = Collections.unmodifiableMap(this.buildersByTag);
    }

    public void buildPolicyXML(PolicyBuilderContext policyBuilderContext) {
        this.buildersByTag.forEach((tag, builder) -> PolicyXMLBuilder.findAndBuildAssertion(tag, builder, policyBuilderContext));
    }

    private static void findAndBuildAssertion(String assertionTag, PolicyAssertionBuilder policyAssertionBuilder, PolicyBuilderContext policyBuilderContext) {
        Document policyDocument = policyBuilderContext.getPolicyDocument();
        Element policyElement = policyDocument.getDocumentElement();
        NodeList includeReferences = policyElement.getElementsByTagName(assertionTag);
        for (int i = 0; i < includeReferences.getLength(); ++i) {
            Node includeElement = includeReferences.item(i);
            if (!(includeElement instanceof Element)) {
                throw new EntityBuilderException("Unexpected Assertion node type: " + includeElement.getNodeType());
            }
            try {
                policyAssertionBuilder.buildAssertionElement((Element)includeElement, policyBuilderContext);
                continue;
            }
            catch (DocumentParseException e) {
                throw new EntityBuilderException(e.getMessage(), e);
            }
        }
    }

    public Map<String, PolicyAssertionBuilder> getAssertionBuildersByTag() {
        return this.buildersByTag;
    }
}

