/*
 * Decompiled with CFR 0.152.
 */
package com.ca.apim.gateway.cagatewayconfig.bundle.builder;

import com.ca.apim.gateway.cagatewayconfig.beans.Bundle;
import com.ca.apim.gateway.cagatewayconfig.beans.SsgActiveConnector;
import com.ca.apim.gateway.cagatewayconfig.bundle.builder.EntityBuilder;
import com.ca.apim.gateway.cagatewayconfig.bundle.builder.PolicyAssertionBuilder;
import com.ca.apim.gateway.cagatewayconfig.bundle.builder.PolicyBuilderContext;
import com.ca.apim.gateway.cagatewayconfig.util.IdGenerator;
import com.ca.apim.gateway.cagatewayconfig.util.xml.DocumentUtils;
import org.w3c.dom.Element;

public class MQRoutingAssertionBuilder
implements PolicyAssertionBuilder {
    @Override
    public void buildAssertionElement(Element assertionElement, PolicyBuilderContext policyBuilderContext) {
        Bundle bundle = policyBuilderContext.getBundle();
        IdGenerator idGenerator = policyBuilderContext.getIdGenerator();
        Element activeConnectorNameElement = DocumentUtils.getSingleChildElement(assertionElement, "L7p:SsgActiveConnectorName", true);
        if (activeConnectorNameElement != null) {
            String activeConnectorName = activeConnectorNameElement.getAttributes().getNamedItem("stringValue").getTextContent();
            activeConnectorNameElement.setAttribute("stringValue", bundle.applyUniqueName(activeConnectorName, EntityBuilder.BundleType.ENVIRONMENT));
            SsgActiveConnector ssgActiveConnector = bundle.getSsgActiveConnectors().get(activeConnectorName);
            String id = ssgActiveConnector != null && ssgActiveConnector.getAnnotatedEntity() != null && ssgActiveConnector.getAnnotatedEntity().getId() != null ? ssgActiveConnector.getAnnotatedEntity().getId() : idGenerator.generate();
            Element activeConnectorGoidElement = DocumentUtils.createElementWithAttribute(policyBuilderContext.getPolicyDocument(), "L7p:SsgActiveConnectorGoid", "goidValue", id);
            assertionElement.insertBefore(activeConnectorGoidElement, activeConnectorNameElement);
            Element activeConnectorIdElement = DocumentUtils.createElementWithAttribute(policyBuilderContext.getPolicyDocument(), "L7p:SsgActiveConnectorId", "goidValue", id);
            assertionElement.insertBefore(activeConnectorIdElement, activeConnectorNameElement);
        }
    }

    @Override
    public String getAssertionTagName() {
        return "L7p:MqNativeRouting";
    }
}

