/*
 * Decompiled with CFR 0.152.
 */
package com.ca.apim.gateway.cagatewayconfig.bundle.builder;

import com.ca.apim.gateway.cagatewayconfig.beans.GatewayEntity;
import com.ca.apim.gateway.cagatewayconfig.bundle.builder.Metadata;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.w3c.dom.Element;

public class Entity {
    public static final String PROPERTY_BUNDLE_ENTITY_NAME = "bundleName";
    public static final String PROPERTY_GUID = "guid";
    public static final String PROPERTY_HAS_ROUTING = "hasRouting";
    private final String type;
    private final String id;
    private final Element xml;
    private final String originalName;
    private final Map<String, Object> properties = new HashMap<String, Object>();
    private String mappingAction;
    private final Map<String, Object> mappingProperties = new HashMap<String, Object>();
    private final GatewayEntity gatewayEntity;

    public Entity(String type, String originalName, String id, Element xml, GatewayEntity gatewayEntity) {
        this.type = type;
        this.originalName = originalName;
        this.id = id;
        this.xml = xml;
        this.gatewayEntity = gatewayEntity;
    }

    public String getType() {
        return this.type;
    }

    public String getId() {
        return this.id;
    }

    public Element getXml() {
        if (this.xml != null) {
            return (Element)this.xml.cloneNode(true);
        }
        return this.xml;
    }

    public Map<String, Object> getProperties() {
        return this.properties;
    }

    public void setProperties(Map<String, Object> properties) {
        if (properties != null) {
            this.properties.clear();
            this.properties.putAll(properties);
        }
    }

    public String getGuid() {
        return (String)this.properties.get(PROPERTY_GUID);
    }

    public String getName() {
        return (String)ObjectUtils.firstNonNull((Object[])new String[]{(String)this.properties.get(PROPERTY_BUNDLE_ENTITY_NAME), this.originalName});
    }

    public String getOriginalName() {
        return this.originalName;
    }

    public boolean isHasRouting() {
        return BooleanUtils.toBooleanDefaultIfNull((Boolean)((Boolean)this.properties.get(PROPERTY_HAS_ROUTING)), (boolean)false);
    }

    public Map<String, Object> getMappingProperties() {
        return this.mappingProperties;
    }

    void setMappingProperty(String key, Object value) {
        this.mappingProperties.put(key, value);
    }

    public String getMappingAction() {
        return this.mappingAction;
    }

    void setMappingAction(String mappingAction) {
        this.mappingAction = mappingAction;
    }

    @JsonIgnore
    public Metadata getMetadata() {
        return new Metadata(){

            @Override
            public String getType() {
                return Entity.this.type;
            }

            @Override
            public String getName() {
                return Entity.this.getName();
            }

            @Override
            @JsonIgnore
            public String getId() {
                return Entity.this.id;
            }

            @Override
            @JsonIgnore
            public String getGuid() {
                return Entity.this.getGuid();
            }
        };
    }

    public GatewayEntity getGatewayEntity() {
        return this.gatewayEntity;
    }
}

