/*
 * Decompiled with CFR 0.152.
 */
package com.ca.apim.gateway.cagatewayconfig.bundle.builder;

import com.ca.apim.gateway.cagatewayconfig.beans.Bundle;
import com.ca.apim.gateway.cagatewayconfig.beans.CassandraConnection;
import com.ca.apim.gateway.cagatewayconfig.beans.StoredPassword;
import com.ca.apim.gateway.cagatewayconfig.bundle.builder.AnnotatedBundle;
import com.ca.apim.gateway.cagatewayconfig.bundle.builder.Entity;
import com.ca.apim.gateway.cagatewayconfig.bundle.builder.EntityBuilder;
import com.ca.apim.gateway.cagatewayconfig.bundle.builder.EntityBuilderException;
import com.ca.apim.gateway.cagatewayconfig.bundle.builder.EntityBuilderHelper;
import com.ca.apim.gateway.cagatewayconfig.util.IdGenerator;
import com.ca.apim.gateway.cagatewayconfig.util.gateway.BuilderUtils;
import com.ca.apim.gateway.cagatewayconfig.util.xml.DocumentUtils;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

@Singleton
public class CassandraConnectionEntityBuilder
implements EntityBuilder {
    private static final Integer ORDER = 1300;
    private final IdGenerator idGenerator;

    @Inject
    CassandraConnectionEntityBuilder(IdGenerator idGenerator) {
        this.idGenerator = idGenerator;
    }

    private List<Entity> buildEntities(Map<String, ?> entities, Bundle bundle, EntityBuilder.BundleType bundleType, Document document) {
        switch (bundleType) {
            case DEPLOYMENT: {
                return entities.entrySet().stream().map(e -> EntityBuilderHelper.getEntityWithOnlyMapping("CASSANDRA_CONFIGURATION", bundle.applyUniqueName((String)e.getKey(), EntityBuilder.BundleType.ENVIRONMENT), this.generateId((CassandraConnection)e.getValue()))).collect(Collectors.toList());
            }
            case ENVIRONMENT: {
                return entities.entrySet().stream().map(e -> this.buildEntity(bundle, bundle.applyUniqueName((String)e.getKey(), bundleType), (CassandraConnection)e.getValue(), document)).collect(Collectors.toList());
            }
        }
        throw new EntityBuilderException("Unknown bundle type: " + (Object)((Object)bundleType));
    }

    @Override
    public List<Entity> build(Bundle bundle, EntityBuilder.BundleType bundleType, Document document) {
        if (bundle instanceof AnnotatedBundle) {
            Map entities = Optional.ofNullable(bundle.getCassandraConnections()).orElse(Collections.emptyMap());
            return this.buildEntities(entities, ((AnnotatedBundle)bundle).getFullBundle(), bundleType, document);
        }
        Map<String, CassandraConnection> entities = bundle.getCassandraConnections();
        return this.buildEntities(entities, bundle, bundleType, document);
    }

    @VisibleForTesting
    Entity buildEntity(Bundle bundle, String name, CassandraConnection connection, Document document) {
        String id = this.generateId(connection);
        Element cassandraElement = DocumentUtils.createElementWithAttributesAndChildren(document, "l7:CassandraConnection", (Map<String, String>)ImmutableMap.of((Object)"id", (Object)id), DocumentUtils.createElementWithTextContent(document, "l7:Name", name), DocumentUtils.createElementWithTextContent(document, "l7:Keyspace", connection.getKeyspace()), DocumentUtils.createElementWithTextContent(document, "l7:ContactPoint", connection.getContactPoint()), DocumentUtils.createElementWithTextContent(document, "l7:Port", connection.getPort()), DocumentUtils.createElementWithTextContent(document, "l7:Username", connection.getUsername()));
        if (connection.getStoredPasswordName() != null) {
            StoredPassword password = bundle.getStoredPasswords().get(connection.getStoredPasswordName());
            if (password == null) {
                throw new EntityBuilderException("Cassandra Connection is referencing missing password '" + connection.getStoredPasswordName() + "'");
            }
            cassandraElement.appendChild(DocumentUtils.createElementWithTextContent(document, "l7:PasswordId", password.getId()));
        }
        cassandraElement.appendChild(DocumentUtils.createElementWithTextContent(document, "l7:Compression", connection.getCompression()));
        cassandraElement.appendChild(DocumentUtils.createElementWithTextContent(document, "l7:Ssl", connection.getSsl()));
        if (CollectionUtils.isNotEmpty(connection.getTlsCiphers())) {
            String ciphers = String.join((CharSequence)",", connection.getTlsCiphers());
            cassandraElement.appendChild(DocumentUtils.createElementWithTextContent(document, "l7:TlsCiphers", ciphers));
        }
        cassandraElement.appendChild(DocumentUtils.createElementWithTextContent(document, "l7:Enabled", Boolean.TRUE.toString()));
        BuilderUtils.buildAndAppendPropertiesElement(connection.getProperties(), document, cassandraElement);
        return EntityBuilderHelper.getEntityWithNameMapping("CASSANDRA_CONFIGURATION", name, id, cassandraElement);
    }

    private String generateId(CassandraConnection cassandraConnection) {
        if (cassandraConnection != null && cassandraConnection.getAnnotatedEntity() != null && StringUtils.isNotBlank((CharSequence)cassandraConnection.getAnnotatedEntity().getId())) {
            return cassandraConnection.getAnnotatedEntity().getId();
        }
        return this.idGenerator.generate();
    }

    @Override
    @NotNull
    public Integer getOrder() {
        return ORDER;
    }
}

