/*
 * Decompiled with CFR 0.152.
 */
package com.ca.apim.gateway.cagatewayconfig.bundle.builder;

import com.ca.apim.gateway.cagatewayconfig.beans.Bundle;
import com.ca.apim.gateway.cagatewayconfig.beans.IdentityProvider;
import com.ca.apim.gateway.cagatewayconfig.bundle.builder.PolicyAssertionBuilder;
import com.ca.apim.gateway.cagatewayconfig.bundle.builder.PolicyBuilderContext;
import com.ca.apim.gateway.cagatewayconfig.util.IdGenerator;
import com.ca.apim.gateway.cagatewayconfig.util.xml.DocumentUtils;
import org.w3c.dom.Element;

public class AuthenticationAssertionBuilder
implements PolicyAssertionBuilder {
    @Override
    public void buildAssertionElement(Element assertionElement, PolicyBuilderContext policyBuilderContext) {
        Bundle bundle = policyBuilderContext.getBundle();
        IdGenerator idGenerator = policyBuilderContext.getIdGenerator();
        Element idProviderNameElement = DocumentUtils.getSingleChildElement(assertionElement, "L7p:IdentityProviderName", true);
        if (idProviderNameElement != null) {
            IdentityProvider identityProvider;
            String idProviderName = idProviderNameElement.getAttributes().getNamedItem("stringValue").getTextContent();
            String id = idProviderName.equals("Internal Identity Provider") ? "0000000000000000fffffffffffffffe" : ((identityProvider = bundle.getIdentityProviders().get(idProviderName)) != null ? (identityProvider.getAnnotatedEntity() != null && identityProvider.getAnnotatedEntity().getId() != null ? identityProvider.getAnnotatedEntity().getId() : identityProvider.getId()) : idGenerator.generate());
            Element idProviderGoidElement = DocumentUtils.createElementWithAttribute(policyBuilderContext.getPolicyDocument(), "L7p:IdentityProviderOid", "goidValue", id);
            assertionElement.insertBefore(idProviderGoidElement, idProviderNameElement);
            assertionElement.removeChild(idProviderNameElement);
        }
    }

    @Override
    public String getAssertionTagName() {
        return "L7p:Authentication";
    }
}

