/*
 * Decompiled with CFR 0.152.
 */
package com.ca.apim.gateway.cagatewayconfig.bundle.builder;

import com.ca.apim.gateway.cagatewayconfig.beans.Annotation;
import com.ca.apim.gateway.cagatewayconfig.util.entity.AnnotationType;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class AnnotationDeserializer
extends JsonDeserializer<Set<Annotation>> {
    private static final Logger LOGGER = Logger.getLogger(AnnotationDeserializer.class.getName());

    public Set<Annotation> deserialize(JsonParser parser, DeserializationContext context) throws IOException {
        ObjectCodec codec = parser.getCodec();
        JsonNode node = (JsonNode)codec.readTree(parser);
        if (node.isArray()) {
            HashSet<Annotation> annotations = new HashSet<Annotation>();
            node.elements().forEachRemaining(ele -> {
                if (ele.isObject() && ele.hasNonNull("type")) {
                    Annotation annotation = new Annotation(ele.get("type").asText());
                    if (AnnotationType.SUPPORTED_ANNOTATION_TYPES.contains(annotation.getType()) && !annotations.contains(annotation)) {
                        annotation.setName(this.getNodeAttribute((JsonNode)ele, "name"));
                        annotation.setId(this.getNodeAttribute((JsonNode)ele, "id"));
                        annotation.setGuid(this.getNodeAttribute((JsonNode)ele, "guid"));
                        annotation.setDescription(this.getNodeAttribute((JsonNode)ele, "description"));
                        if (ele.hasNonNull("tags")) {
                            ArrayList<String> tags = new ArrayList<String>();
                            ele.get("tags").elements().forEachRemaining(e -> tags.add(e.textValue()));
                            annotation.setTags(tags);
                        }
                        annotations.add(annotation);
                    } else {
                        this.alertUser(annotation.getType());
                    }
                } else if (ele.isTextual()) {
                    Annotation annotation = new Annotation(ele.asText());
                    if (AnnotationType.SUPPORTED_ANNOTATION_TYPES.contains(annotation.getType()) && !annotations.contains(annotation)) {
                        annotations.add(annotation);
                    } else {
                        this.alertUser(annotation.getType());
                    }
                }
            });
            return annotations;
        }
        return Collections.emptySet();
    }

    private String getNodeAttribute(JsonNode node, String attribute) {
        if (node.hasNonNull(attribute)) {
            return node.get(attribute).asText();
        }
        return "";
    }

    private void alertUser(String annotationType) {
        LOGGER.log(Level.WARNING, "Found unsupported or duplicated annotation: {0}, ignoring it.", annotationType);
    }
}

