/*
 * Decompiled with CFR 0.152.
 */
package com.ca.apim.gateway.cagatewayconfig.beans;

import com.ca.apim.gateway.cagatewayconfig.beans.Annotation;
import com.ca.apim.gateway.cagatewayconfig.beans.Bundle;
import com.ca.apim.gateway.cagatewayconfig.beans.Encass;
import com.ca.apim.gateway.cagatewayconfig.beans.GatewayEntity;
import com.ca.apim.gateway.cagatewayconfig.bundle.builder.AnnotableEntity;
import com.ca.apim.gateway.cagatewayconfig.bundle.builder.AnnotatedEntity;
import com.ca.apim.gateway.cagatewayconfig.bundle.builder.AnnotationDeserializer;
import com.ca.apim.gateway.cagatewayconfig.config.spec.ConfigurationFile;
import com.ca.apim.gateway.cagatewayconfig.config.spec.EnvironmentType;
import com.ca.apim.gateway.cagatewayconfig.util.IdGenerator;
import com.ca.apim.gateway.cagatewayconfig.util.file.DocumentFileUtils;
import com.ca.apim.gateway.cagatewayconfig.util.gateway.CertificateUtils;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableMap;
import java.io.File;
import java.math.BigInteger;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import javax.inject.Named;
import org.apache.commons.lang3.ObjectUtils;
import org.jetbrains.annotations.Nullable;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@Named(value="TRUSTED_CERT")
@ConfigurationFile(name="trusted-certs", type=ConfigurationFile.FileType.JSON_YAML)
@EnvironmentType(value="CERTIFICATE")
public class TrustedCert
extends GatewayEntity
implements AnnotableEntity {
    private boolean verifyHostname;
    private boolean trustedForSsl;
    private boolean trustedAsSamlAttestingEntity;
    private boolean trustAnchor;
    private boolean revocationCheckingEnabled;
    private boolean trustedForSigningClientCerts;
    private boolean trustedForSigningServerCerts;
    private boolean trustedAsSamlIssuer;
    private CertificateData certificateData;
    @JsonDeserialize(using=AnnotationDeserializer.class)
    private Set<Annotation> annotations;
    @JsonIgnore
    private AnnotatedEntity<? extends GatewayEntity> annotatedEntity;

    public TrustedCert() {
    }

    public TrustedCert(Map<String, Object> properties, CertificateData certificateData) {
        this((Map)ObjectUtils.firstNonNull((Object[])new Map[]{properties, Collections.emptyMap()}));
        this.certificateData = certificateData;
    }

    private TrustedCert(Builder builder) {
        this(builder.properties, new CertificateData(builder.encodedData));
        this.setId(builder.id);
        this.setName(builder.name);
    }

    public TrustedCert(Map<String, Object> properties) {
        this.verifyHostname = this.extractBoolean(properties, "verifyHostname");
        this.trustedForSsl = this.extractBoolean(properties, "trustedForSsl");
        this.trustedAsSamlAttestingEntity = this.extractBoolean(properties, "trustedAsSamlAttestingEntity");
        this.trustAnchor = this.extractBoolean(properties, "trustAnchor");
        this.revocationCheckingEnabled = this.extractBoolean(properties, "revocationCheckingEnabled");
        this.trustedForSigningClientCerts = this.extractBoolean(properties, "trustedForSigningClientCerts");
        this.trustedForSigningServerCerts = this.extractBoolean(properties, "trustedForSigningServerCerts");
        this.trustedAsSamlIssuer = this.extractBoolean(properties, "trustedAsSamlIssuer");
    }

    public Map<String, Object> createProperties() {
        return ImmutableMap.builder().put((Object)"verifyHostname", (Object)this.verifyHostname).put((Object)"trustedForSsl", (Object)this.trustedForSsl).put((Object)"trustedAsSamlAttestingEntity", (Object)this.trustedAsSamlAttestingEntity).put((Object)"trustAnchor", (Object)this.trustAnchor).put((Object)"revocationCheckingEnabled", (Object)this.revocationCheckingEnabled).put((Object)"trustedForSigningClientCerts", (Object)this.trustedForSigningClientCerts).put((Object)"trustedForSigningServerCerts", (Object)this.trustedForSigningServerCerts).put((Object)"trustedAsSamlIssuer", (Object)this.trustedAsSamlIssuer).build();
    }

    public void setCertificateData(CertificateData certificateData) {
        this.certificateData = certificateData;
    }

    public CertificateData getCertificateData() {
        return this.certificateData;
    }

    private boolean extractBoolean(Map<String, Object> properties, String keyName) {
        return properties.get(keyName) != null && Boolean.parseBoolean(properties.get(keyName).toString());
    }

    public boolean isVerifyHostname() {
        return this.verifyHostname;
    }

    public boolean isTrustedForSsl() {
        return this.trustedForSsl;
    }

    public boolean isTrustedAsSamlAttestingEntity() {
        return this.trustedAsSamlAttestingEntity;
    }

    public boolean isTrustAnchor() {
        return this.trustAnchor;
    }

    public boolean isRevocationCheckingEnabled() {
        return this.revocationCheckingEnabled;
    }

    public boolean isTrustedForSigningClientCerts() {
        return this.trustedForSigningClientCerts;
    }

    public boolean isTrustedForSigningServerCerts() {
        return this.trustedForSigningServerCerts;
    }

    public boolean isTrustedAsSamlIssuer() {
        return this.trustedAsSamlIssuer;
    }

    @Override
    public Set<Annotation> getAnnotations() {
        return this.annotations;
    }

    public void setAnnotations(Set<Annotation> annotations) {
        this.annotations = annotations;
    }

    @Override
    public void preWrite(File configFolder, DocumentFileUtils documentFileUtils) {
        File certFolder = new File(configFolder, "certificates");
        documentFileUtils.createFolder(certFolder.toPath());
        CertificateUtils.writeCertificateData(certFolder, this.getName(), this.getCertificateData().getEncodedData());
        this.certificateData = null;
    }

    public AnnotatedEntity getAnnotatedEntity() {
        if (this.annotatedEntity == null && this.annotations != null) {
            this.annotatedEntity = this.createAnnotatedEntity();
        }
        return this.annotatedEntity;
    }

    @VisibleForTesting
    public void setAnnotatedEntity(AnnotatedEntity<Encass> annotatedEntity) {
        this.annotatedEntity = annotatedEntity;
    }

    @Override
    public String getEntityType() {
        return "TRUSTED_CERT";
    }

    @Override
    public void postLoad(String entityKey, Bundle bundle, @Nullable File rootFolder, IdGenerator idGenerator) {
        super.postLoad(entityKey, bundle, rootFolder, idGenerator);
        this.setName(entityKey);
    }

    public static class Builder {
        private String id;
        private String name;
        private Map<String, Object> properties;
        private String encodedData;

        public Builder id(String id) {
            this.id = id;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder properties(Map<String, Object> properties) {
            this.properties = properties;
            return this;
        }

        public Builder encodedData(String encodedData) {
            this.encodedData = encodedData;
            return this;
        }

        public TrustedCert build() {
            return new TrustedCert(this);
        }
    }

    public static class CertificateData {
        private String issuerName;
        private BigInteger serialNumber;
        private String subjectName;
        private String encodedData;

        public CertificateData() {
        }

        public CertificateData(String issuerName, BigInteger serialNumber, String subjectName, String encodedData) {
            this.issuerName = issuerName;
            this.serialNumber = serialNumber;
            this.subjectName = subjectName;
            this.encodedData = encodedData;
        }

        public CertificateData(String encodedData) {
            this.encodedData = encodedData;
        }

        public String getIssuerName() {
            return this.issuerName;
        }

        public BigInteger getSerialNumber() {
            return this.serialNumber;
        }

        public String getSubjectName() {
            return this.subjectName;
        }

        public String getEncodedData() {
            return this.encodedData;
        }
    }
}

