/*
 * Decompiled with CFR 0.152.
 */
package com.ca.apim.gateway.cagatewayconfig.beans;

import com.ca.apim.gateway.cagatewayconfig.beans.Bundle;
import com.ca.apim.gateway.cagatewayconfig.beans.GatewayEntity;
import com.ca.apim.gateway.cagatewayconfig.beans.KeyStoreType;
import com.ca.apim.gateway.cagatewayconfig.config.loader.ConfigLoadException;
import com.ca.apim.gateway.cagatewayconfig.config.spec.ConfigurationFile;
import com.ca.apim.gateway.cagatewayconfig.config.spec.EnvironmentType;
import com.ca.apim.gateway.cagatewayconfig.util.IdGenerator;
import com.ca.apim.gateway.cagatewayconfig.util.file.SupplierWithIO;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.io.File;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Collection;
import javax.inject.Named;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@Named(value="SSG_KEY_ENTRY")
@ConfigurationFile(name="private-keys", type=ConfigurationFile.FileType.JSON_YAML)
@EnvironmentType(value="PRIVATE_KEY")
public class PrivateKey
extends GatewayEntity {
    public static final String SSL_DEFAULT_PRIVATE_KEY = "SSL";
    private String keystore;
    private String algorithm;
    private String keyPassword;
    @JsonIgnore
    private KeyStoreType keyStoreType;
    private SupplierWithIO<InputStream> privateKeyFile;

    public PrivateKey() {
    }

    private PrivateKey(Builder builder) {
        this.setId(builder.id);
        this.setAlias(builder.alias);
        this.setKeyStoreType(builder.keystore);
        this.setAlgorithm(builder.algorithm);
    }

    @JsonIgnore
    public String getAlias() {
        return this.getName();
    }

    public void setAlias(String alias) {
        this.setName(alias);
    }

    public String getKeystore() {
        return this.keystore;
    }

    public void setKeystore(String keystore) {
        this.keystore = keystore;
    }

    public String getAlgorithm() {
        return this.algorithm;
    }

    public void setAlgorithm(String algorithm) {
        this.algorithm = algorithm;
    }

    public KeyStoreType getKeyStoreType() {
        return this.keyStoreType;
    }

    public void setKeyStoreType(KeyStoreType keyStoreType) {
        this.keyStoreType = keyStoreType;
    }

    public String getKeyPassword() {
        return this.keyPassword;
    }

    public void setKeyPassword(String keyPassword) {
        this.keyPassword = keyPassword;
    }

    public SupplierWithIO<InputStream> getPrivateKeyFile() {
        return this.privateKeyFile;
    }

    public void setPrivateKeyFile(SupplierWithIO<InputStream> privateKeyFile) {
        this.privateKeyFile = privateKeyFile;
    }

    @Override
    public void postLoad(String entityKey, Bundle bundle, File rootFolder, IdGenerator idGenerator) {
        this.setAlias(entityKey);
        this.setKeyStoreType(KeyStoreType.fromName(this.getKeystore()));
        if (bundle.getPrivateKeyFiles().get(this.getAlias()) != null) {
            this.setPrivateKeyFile(bundle.getPrivateKeyFiles().get(this.getAlias()));
        } else if (rootFolder != null && this.getPrivateKeyFile() == null) {
            PrivateKey.loadPrivateKey(this, new File(rootFolder, "config/privateKeys"), false);
            bundle.getPrivateKeyFiles().put(this.getAlias(), this.getPrivateKeyFile());
        }
    }

    public static void loadFromDirectory(Collection<PrivateKey> privateKeys, File privateKeysDirectory, boolean failOnMissingKeys) {
        if (!privateKeys.isEmpty()) {
            if (!privateKeysDirectory.exists() && failOnMissingKeys) {
                throw new ConfigLoadException("Directory specified for private keys does not exist: " + privateKeysDirectory.getPath());
            }
            if (privateKeysDirectory.exists()) {
                privateKeys.forEach(k -> PrivateKey.loadPrivateKey(k, privateKeysDirectory, failOnMissingKeys));
            }
        }
    }

    private static void loadPrivateKey(PrivateKey k, File privateKeysDirectory, boolean failOnMissingKeys) {
        File pk = new File(privateKeysDirectory, k.getAlias() + ".p12");
        if (pk.exists()) {
            k.setPrivateKeyFile(() -> Files.newInputStream(pk.toPath(), new OpenOption[0]));
        } else if (failOnMissingKeys) {
            throw new ConfigLoadException("Private Key file for key '" + k.getAlias() + "' not found in the private keys directory specified: " + privateKeysDirectory.getPath());
        }
    }

    public static class Builder {
        private String id;
        private String alias;
        private KeyStoreType keystore;
        private String algorithm;

        public Builder setId(String id) {
            this.id = id;
            return this;
        }

        public Builder setAlias(String alias) {
            this.alias = alias;
            return this;
        }

        public Builder setKeystore(KeyStoreType keystore) {
            this.keystore = keystore;
            return this;
        }

        public Builder setAlgorithm(String algorithm) {
            this.algorithm = algorithm;
            return this;
        }

        public PrivateKey build() {
            return new PrivateKey(this);
        }
    }
}

