/*
 * Decompiled with CFR 0.152.
 */
package com.ca.apim.gateway.cagatewayconfig.beans;

import com.ca.apim.gateway.cagatewayconfig.beans.GatewayEntity;
import com.ca.apim.gateway.cagatewayconfig.config.spec.ConfigurationFile;
import com.ca.apim.gateway.cagatewayconfig.config.spec.EnvironmentType;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.inject.Named;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@Named(value="SSG_CONNECTOR")
@ConfigurationFile(name="listen-ports", type=ConfigurationFile.FileType.JSON_YAML)
@EnvironmentType(value="LISTEN_PORT")
public class ListenPort
extends GatewayEntity {
    public static final String PROTOCOL_HTTP = "HTTP";
    public static final String PROTOCOL_HTTPS = "HTTPS";
    public static final String PROTOCOL_FTP = "FTP";
    public static final String PROTOCOL_FTPS = "FTPS";
    public static final Integer HTTP_DEFAULT_PORT = 8080;
    public static final Integer HTTPS_DEFAULT_PORT = 8443;
    public static final String DEFAULT_HTTP_8080 = "Default HTTP (8080)";
    public static final String DEFAULT_HTTPS_8443 = "Default HTTPS (8443)";
    public static final List<String> DEFAULT_RECOMMENDED_CIPHERS = Collections.unmodifiableList(Arrays.asList("TLS_ECDHE_RSA_WITH_AES_256_GCM_SHA384", "TLS_ECDHE_ECDSA_WITH_AES_256_GCM_SHA384", "TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA384", "TLS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA384", "TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA", "TLS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA", "TLS_DHE_RSA_WITH_AES_256_GCM_SHA384", "TLS_DHE_RSA_WITH_AES_256_CBC_SHA256", "TLS_DHE_RSA_WITH_AES_256_CBC_SHA", "TLS_ECDHE_RSA_WITH_AES_128_GCM_SHA256", "TLS_ECDHE_ECDSA_WITH_AES_128_GCM_SHA256", "TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA256", "TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA256", "TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA", "TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA", "TLS_DHE_RSA_WITH_AES_128_GCM_SHA256", "TLS_DHE_RSA_WITH_AES_128_CBC_SHA256", "TLS_DHE_RSA_WITH_AES_128_CBC_SHA", "TLS_ECDH_RSA_WITH_AES_256_GCM_SHA384", "TLS_ECDH_ECDSA_WITH_AES_256_GCM_SHA384", "TLS_ECDH_RSA_WITH_AES_256_CBC_SHA384", "TLS_ECDH_ECDSA_WITH_AES_256_CBC_SHA384", "TLS_ECDH_RSA_WITH_AES_256_CBC_SHA", "TLS_ECDH_ECDSA_WITH_AES_256_CBC_SHA", "TLS_RSA_WITH_AES_256_GCM_SHA384", "TLS_RSA_WITH_AES_256_CBC_SHA256", "TLS_RSA_WITH_AES_256_CBC_SHA", "TLS_ECDH_RSA_WITH_AES_128_GCM_SHA256", "TLS_ECDH_ECDSA_WITH_AES_128_GCM_SHA256", "TLS_ECDH_RSA_WITH_AES_128_CBC_SHA256", "TLS_ECDH_ECDSA_WITH_AES_128_CBC_SHA256", "TLS_ECDH_RSA_WITH_AES_128_CBC_SHA", "TLS_ECDH_ECDSA_WITH_AES_128_CBC_SHA", "TLS_RSA_WITH_AES_128_GCM_SHA256", "TLS_RSA_WITH_AES_128_CBC_SHA256", "TLS_RSA_WITH_AES_128_CBC_SHA"));
    public static final List<String> TLS_VERSIONS = Collections.unmodifiableList(Arrays.asList("TLSv1", "TLSv1.1", "TLSv1.2"));
    private String protocol;
    private int port;
    private Set<String> enabledFeatures;
    private ListenPortTlsSettings tlsSettings;
    private Map<String, Object> properties;
    private String targetServiceReference;

    public ListenPort() {
    }

    private ListenPort(Builder builder) {
        this.setId(builder.id);
        this.setName(builder.name);
        this.protocol = builder.protocol;
        this.port = builder.port;
        this.enabledFeatures = builder.enabledFeatures;
        this.tlsSettings = builder.tlsSettings;
        this.properties = builder.properties;
        this.targetServiceReference = builder.targetServiceReference;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public Set<String> getEnabledFeatures() {
        return this.enabledFeatures;
    }

    public void setEnabledFeatures(Set<String> enabledFeatures) {
        this.enabledFeatures = enabledFeatures;
    }

    public Map<String, Object> getProperties() {
        return this.properties;
    }

    public void setProperties(Map<String, Object> properties) {
        this.properties = properties;
    }

    public ListenPortTlsSettings getTlsSettings() {
        return this.tlsSettings;
    }

    public void setTlsSettings(ListenPortTlsSettings tlsSettings) {
        this.tlsSettings = tlsSettings;
    }

    public String getTargetServiceReference() {
        return this.targetServiceReference;
    }

    public void setTargetServiceReference(String targetServiceReference) {
        this.targetServiceReference = targetServiceReference;
    }

    public static class Builder {
        private String id;
        private String name;
        private String protocol;
        private int port;
        private Set<String> enabledFeatures;
        private ListenPortTlsSettings tlsSettings;
        private Map<String, Object> properties;
        private String targetServiceReference;

        public Builder id(String id) {
            this.id = id;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder protocol(String protocol) {
            this.protocol = protocol;
            return this;
        }

        public Builder port(int port) {
            this.port = port;
            return this;
        }

        public Builder enabledFeatures(Set<String> enabledFeatures) {
            this.enabledFeatures = enabledFeatures;
            return this;
        }

        public Builder tlsSettings(ListenPortTlsSettings tlsSettings) {
            this.tlsSettings = tlsSettings;
            return this;
        }

        public Builder properties(Map<String, Object> properties) {
            this.properties = properties;
            return this;
        }

        public Builder targetServiceReference(String targetServiceReference) {
            this.targetServiceReference = targetServiceReference;
            return this;
        }

        public ListenPort build() {
            return new ListenPort(this);
        }
    }

    public static enum Feature {
        MESSAGE_INPUT("Published service message input"),
        ADMIN_REMOTE_SSM("Policy Manager access"),
        ADMIN_REMOTE_ESM("Enterprise Manager access"),
        ADMIN_REMOTE("Administrative access"),
        ADMIN_APPLET("Browser-based administration"),
        POLICYDISCO("Policy download service"),
        PING("Ping service"),
        STS("WS-Trust security token service"),
        CSRHANDLER("Certificate signing service"),
        PASSWD("Password changing service"),
        WSDLPROXY("WSDL download service"),
        SNMPQUERY("SNMP Query service"),
        OTHER_SERVLETS("Built-in services"),
        PC_NODE_API("Node Control"),
        NODE_COMMUNICATION("Inter-Node Communication");

        private final String description;

        private Feature(String description) {
            this.description = description;
        }

        public String getDescription() {
            return this.description;
        }
    }

    public static enum ClientAuthentication {
        NONE("None"),
        OPTIONAL("Optional"),
        REQUIRED("Required");

        private String type;

        private ClientAuthentication(String type) {
            this.type = type;
        }

        public String getType() {
            return this.type;
        }

        public static ClientAuthentication fromType(String type) {
            return Arrays.stream(ClientAuthentication.values()).filter(c -> c.type.equals(type)).findFirst().orElse(null);
        }
    }

    public static class ListenPortTlsSettings {
        public static final String TLSV1 = "TLSv1";
        public static final String TLSV11 = "TLSv1.1";
        public static final String TLSV12 = "TLSv1.2";
        private ClientAuthentication clientAuthentication;
        private String privateKey;
        private Set<String> enabledVersions;
        private Set<String> enabledCipherSuites;
        private Map<String, Object> properties;

        public ClientAuthentication getClientAuthentication() {
            return this.clientAuthentication;
        }

        public void setClientAuthentication(ClientAuthentication clientAuthentication) {
            this.clientAuthentication = clientAuthentication;
        }

        public String getPrivateKey() {
            return this.privateKey;
        }

        public void setPrivateKey(String privateKey) {
            this.privateKey = privateKey;
        }

        public Set<String> getEnabledVersions() {
            return this.enabledVersions;
        }

        public void setEnabledVersions(Set<String> enabledVersions) {
            this.enabledVersions = enabledVersions;
        }

        public Set<String> getEnabledCipherSuites() {
            return this.enabledCipherSuites;
        }

        public void setEnabledCipherSuites(Set<String> enabledCipherSuites) {
            this.enabledCipherSuites = enabledCipherSuites;
        }

        public Map<String, Object> getProperties() {
            return this.properties;
        }

        public void setProperties(Map<String, Object> properties) {
            this.properties = properties;
        }
    }
}

