/*
 * Decompiled with CFR 0.152.
 */
package com.ca.apim.gateway.cagatewayconfig.beans;

import com.ca.apim.gateway.cagatewayconfig.beans.Annotation;
import com.ca.apim.gateway.cagatewayconfig.beans.Bundle;
import com.ca.apim.gateway.cagatewayconfig.beans.Encass;
import com.ca.apim.gateway.cagatewayconfig.beans.GatewayEntity;
import com.ca.apim.gateway.cagatewayconfig.bundle.builder.AnnotableEntity;
import com.ca.apim.gateway.cagatewayconfig.bundle.builder.AnnotatedEntity;
import com.ca.apim.gateway.cagatewayconfig.bundle.builder.AnnotationDeserializer;
import com.ca.apim.gateway.cagatewayconfig.config.loader.ConfigLoadException;
import com.ca.apim.gateway.cagatewayconfig.config.spec.ConfigurationFile;
import com.ca.apim.gateway.cagatewayconfig.config.spec.EnvironmentType;
import com.ca.apim.gateway.cagatewayconfig.util.IdGenerator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.util.Map;
import java.util.Set;
import javax.inject.Named;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@Named(value="JDBC_CONNECTION")
@ConfigurationFile(name="jdbc-connections", type=ConfigurationFile.FileType.JSON_YAML)
@EnvironmentType(value="JDBC_CONNECTION")
public class JdbcConnection
extends GatewayEntity
implements AnnotableEntity {
    private String driverClass;
    private String jdbcUrl;
    private Map<String, Object> properties;
    private String user;
    private String passwordRef;
    private Integer minimumPoolSize;
    private Integer maximumPoolSize;
    private String password;
    @JsonDeserialize(using=AnnotationDeserializer.class)
    private Set<Annotation> annotations;
    @JsonIgnore
    private AnnotatedEntity<? extends GatewayEntity> annotatedEntity;

    @Override
    public Set<Annotation> getAnnotations() {
        return this.annotations;
    }

    public void setAnnotations(Set<Annotation> annotations) {
        this.annotations = annotations;
    }

    public AnnotatedEntity getAnnotatedEntity() {
        if (this.annotatedEntity == null && this.annotations != null) {
            this.annotatedEntity = this.createAnnotatedEntity();
        }
        return this.annotatedEntity;
    }

    @Override
    public String getEntityType() {
        return "JDBC_CONNECTION";
    }

    @VisibleForTesting
    public void setAnnotatedEntity(AnnotatedEntity<Encass> annotatedEntity) {
        this.annotatedEntity = annotatedEntity;
    }

    public JdbcConnection() {
    }

    private JdbcConnection(Builder builder) {
        this.setId(builder.id);
        this.setName(builder.name);
        this.driverClass = builder.driverClass;
        this.jdbcUrl = builder.jdbcUrl;
        this.properties = builder.properties;
        this.user = builder.user;
        this.minimumPoolSize = builder.minimumPoolSize;
        this.maximumPoolSize = builder.maximumPoolSize;
        this.passwordRef = builder.passwordRef;
        this.password = builder.password;
    }

    public String getDriverClass() {
        return this.driverClass;
    }

    public void setDriverClass(String driverClass) {
        this.driverClass = driverClass;
    }

    public String getJdbcUrl() {
        return this.jdbcUrl;
    }

    public void setJdbcUrl(String jdbcUrl) {
        this.jdbcUrl = jdbcUrl;
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public String getPasswordRef() {
        return this.passwordRef;
    }

    public void setPasswordRef(String passwordRef) {
        this.passwordRef = passwordRef;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public Integer getMinimumPoolSize() {
        return this.minimumPoolSize;
    }

    public void setMinimumPoolSize(Integer minimumPoolSize) {
        this.minimumPoolSize = minimumPoolSize;
    }

    public Integer getMaximumPoolSize() {
        return this.maximumPoolSize;
    }

    public void setMaximumPoolSize(Integer maximumPoolSize) {
        this.maximumPoolSize = maximumPoolSize;
    }

    public Map<String, Object> getProperties() {
        return this.properties;
    }

    public void setProperties(Map<String, Object> properties) {
        this.properties = properties;
    }

    @Override
    public void postLoad(String entityKey, Bundle bundle, File rootFolder, IdGenerator idGenerator) {
        this.setName(entityKey);
        if (this.getPasswordRef() != null && this.getPassword() != null) {
            throw new ConfigLoadException("Cannot specify both a password reference and a password for jdbc connection: " + entityKey);
        }
    }

    public static class Builder {
        private String id;
        private String name;
        private String driverClass;
        private String jdbcUrl;
        private String user;
        private String passwordRef;
        private String password;
        private Integer minimumPoolSize;
        private Integer maximumPoolSize;
        private Map<String, Object> properties;

        public Builder id(String id) {
            this.id = id;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder driverClass(String driverClass) {
            this.driverClass = driverClass;
            return this;
        }

        public Builder jdbcUrl(String jdbcUrl) {
            this.jdbcUrl = jdbcUrl;
            return this;
        }

        public Builder properties(Map<String, Object> properties) {
            this.properties = properties;
            return this;
        }

        public Builder user(String user) {
            this.user = user;
            return this;
        }

        public Builder passwordRef(String passwordRef) {
            this.passwordRef = passwordRef;
            return this;
        }

        public Builder password(String password) {
            this.password = password;
            return this;
        }

        public Builder minimumPoolSize(Integer minimumPoolSize) {
            this.minimumPoolSize = minimumPoolSize;
            return this;
        }

        public Builder maximumPoolSize(Integer maximumPoolSize) {
            this.maximumPoolSize = maximumPoolSize;
            return this;
        }

        public JdbcConnection build() {
            return new JdbcConnection(this);
        }
    }
}

