/*
 * Decompiled with CFR 0.152.
 */
package com.ca.apim.gateway.cagatewayconfig;

import com.ca.apim.gateway.cagatewayconfig.ProjectInfo;
import com.ca.apim.gateway.cagatewayconfig.beans.Bundle;
import com.ca.apim.gateway.cagatewayconfig.beans.DependentBundle;
import com.ca.apim.gateway.cagatewayconfig.beans.GatewayEntity;
import com.ca.apim.gateway.cagatewayconfig.beans.Policy;
import com.ca.apim.gateway.cagatewayconfig.beans.Service;
import com.ca.apim.gateway.cagatewayconfig.bundle.builder.BundleArtifacts;
import com.ca.apim.gateway.cagatewayconfig.bundle.builder.BundleEntityBuilder;
import com.ca.apim.gateway.cagatewayconfig.bundle.builder.EntityBuilder;
import com.ca.apim.gateway.cagatewayconfig.config.loader.EntityLoader;
import com.ca.apim.gateway.cagatewayconfig.config.loader.EntityLoaderRegistry;
import com.ca.apim.gateway.cagatewayconfig.config.loader.FolderLoaderUtils;
import com.ca.apim.gateway.cagatewayconfig.environment.BundleCache;
import com.ca.apim.gateway.cagatewayconfig.util.file.DocumentFileUtils;
import com.ca.apim.gateway.cagatewayconfig.util.file.JsonFileUtils;
import com.ca.apim.gateway.cagatewayconfig.util.xml.DocumentTools;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.xml.parsers.DocumentBuilder;
import org.w3c.dom.Document;

@Singleton
public class BundleFileBuilder {
    private final DocumentFileUtils documentFileUtils;
    private final JsonFileUtils jsonFileUtils;
    private final EntityLoaderRegistry entityLoaderRegistry;
    private final BundleEntityBuilder bundleEntityBuilder;
    private final BundleCache cache;
    private final DocumentTools documentTools;
    private static final Logger LOGGER = Logger.getLogger(BundleFileBuilder.class.getName());

    @Inject
    public BundleFileBuilder(DocumentTools documentTools, DocumentFileUtils documentFileUtils, JsonFileUtils jsonFileUtils, EntityLoaderRegistry entityLoaderRegistry, BundleEntityBuilder bundleEntityBuilder, BundleCache cache) {
        this.documentFileUtils = documentFileUtils;
        this.jsonFileUtils = jsonFileUtils;
        this.documentTools = documentTools;
        this.entityLoaderRegistry = entityLoaderRegistry;
        this.bundleEntityBuilder = bundleEntityBuilder;
        this.cache = cache;
    }

    public void buildBundle(File rootDir, File outputDir, List<DependentBundle> dependencies, ProjectInfo projectInfo) {
        DocumentBuilder documentBuilder = this.documentTools.getDocumentBuilder();
        Document document = documentBuilder.newDocument();
        Bundle bundle = new Bundle(projectInfo);
        if (rootDir != null) {
            Collection<EntityLoader> entityLoaders = this.entityLoaderRegistry.getEntityLoaders();
            entityLoaders.parallelStream().forEach(e -> e.load(bundle, rootDir));
            FolderLoaderUtils.createFolders(bundle, rootDir, bundle.getServices());
            HashSet<Bundle> dependencyBundles = new HashSet<Bundle>();
            for (DependentBundle dependentBundle : dependencies) {
                Bundle bundleDependency;
                File bundleDirectory;
                List<Object> metadataFiles = new ArrayList();
                File dependencyFile = dependentBundle.getDependencyFile();
                if (!dependencyFile.exists() && (bundleDirectory = dependencyFile.getParentFile()) != null && bundleDirectory.isDirectory()) {
                    File[] files = bundleDirectory.listFiles();
                    metadataFiles = Stream.of(files).filter(file -> file.getName().endsWith(JsonFileUtils.METADATA_FILE_NAME_SUFFIX)).collect(Collectors.toList());
                }
                if (!metadataFiles.isEmpty()) {
                    metadataFiles.forEach(file -> {
                        Bundle bundleDependency = this.cache.getBundleFromMetadataFile((File)file);
                        if (bundleDependency != null) {
                            dependencyBundles.add(bundleDependency);
                        }
                    });
                    continue;
                }
                if (dependencyFile.getName().endsWith(JsonFileUtils.METADATA_FILE_NAME_SUFFIX)) {
                    bundleDependency = this.cache.getBundleFromMetadataFile(dependencyFile);
                    if (bundleDependency == null) continue;
                    bundleDependency.setDependentBundleFrom(dependentBundle);
                    dependencyBundles.add(bundleDependency);
                    continue;
                }
                if (!dependencyFile.getName().endsWith(".bundle")) continue;
                bundleDependency = this.cache.getBundleFromFile(dependencyFile);
                bundleDependency.setDependentBundleFrom(dependentBundle);
                dependencyBundles.add(bundleDependency);
            }
            bundle.setDependencies(dependencyBundles);
            if (!dependencyBundles.isEmpty()) {
                this.logOverriddenEntities(bundle, dependencyBundles, Service.class);
                this.logOverriddenEntities(bundle, dependencyBundles, Policy.class);
            }
        }
        Map<String, BundleArtifacts> bundleElementMap = this.bundleEntityBuilder.build(bundle, EntityBuilder.BundleType.DEPLOYMENT, document, projectInfo);
        bundleElementMap.forEach((k, v) -> this.writeBundleArtifacts((String)k, (BundleArtifacts)v, outputDir));
    }

    private void writeBundleArtifacts(String bundleName, BundleArtifacts bundleArtifacts, File outputDir) {
        this.documentFileUtils.createFile(bundleArtifacts.getInstallBundle().getElement(), new File(outputDir, bundleArtifacts.getInstallBundle().getFilename()).toPath());
        this.documentFileUtils.createFile(bundleArtifacts.getDeleteBundle().getElement(), new File(outputDir, bundleArtifacts.getDeleteBundle().getFilename()).toPath());
        this.jsonFileUtils.createBundleMetadataFile(bundleArtifacts.getBundleMetadata(), bundleName, outputDir);
    }

    protected <E extends GatewayEntity> void logOverriddenEntities(Bundle bundle, Set<Bundle> dependencyBundles, Class<E> entityClass) {
        bundle.getEntities(entityClass).keySet().forEach(entityName -> dependencyBundles.forEach(dependencyBundle -> {
            if (dependencyBundle.getEntities(entityClass).containsKey(entityName)) {
                LOGGER.log(Level.INFO, "{0} policy will be overwritten by local version", entityName);
            }
        }));
    }
}

