/*
 * Decompiled with CFR 0.152.
 */
package com.c4_soft.springaddons.test.security.web.servlet.request;

import com.c4_soft.oauth2.rfc7519.JwtClaimSet;
import com.c4_soft.springaddons.test.security.support.jwt.JwtClaimSetAuthenticationRequestPostProcessor;
import com.c4_soft.springaddons.test.security.web.servlet.request.ServletClaimSetAuthenticationUnitTestingSupport;
import java.util.Map;
import java.util.Set;
import org.mockito.Mockito;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.test.context.TestConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Import;
import org.springframework.context.annotation.Scope;
import org.springframework.core.convert.converter.Converter;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.oauth2.jwt.JwtDecoder;

@Import(value={UnitTestConfig.class})
public class ServletJwtClaimSetAuthenticationUnitTestingSupport
extends ServletClaimSetAuthenticationUnitTestingSupport<JwtClaimSet, JwtClaimSetAuthenticationRequestPostProcessor> {
    @Override
    public JwtClaimSetAuthenticationRequestPostProcessor authentication() {
        return (JwtClaimSetAuthenticationRequestPostProcessor)this.beanFactory.getBean(JwtClaimSetAuthenticationRequestPostProcessor.class);
    }

    @TestConfiguration
    public static class UnitTestConfig {
        @ConditionalOnMissingBean
        @Bean
        public JwtDecoder jwtDecoder() {
            return (JwtDecoder)Mockito.mock(JwtDecoder.class);
        }

        @Bean
        @Scope(value="prototype")
        public JwtClaimSetAuthenticationRequestPostProcessor claimSetAuthenticationRequestPostProcessor(Converter<Map<String, Object>, Set<GrantedAuthority>> authoritiesConverter) {
            return new JwtClaimSetAuthenticationRequestPostProcessor(authoritiesConverter);
        }

        @Bean
        public ServletJwtClaimSetAuthenticationUnitTestingSupport testingSupport() {
            return new ServletJwtClaimSetAuthenticationUnitTestingSupport();
        }
    }
}

