/*
 * Decompiled with CFR 0.152.
 */
package com.c4_soft.springaddons.test.security.support.missingpublicapi;

import com.c4_soft.springaddons.test.security.support.AuthenticationBuilder;
import com.c4_soft.springaddons.test.security.support.missingpublicapi.JwtBuilder;
import java.util.Collection;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.convert.converter.Converter;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.oauth2.jwt.Jwt;
import org.springframework.security.oauth2.server.resource.authentication.JwtAuthenticationToken;

public class JwtAuthenticationTokenBuilder<T extends JwtAuthenticationTokenBuilder<T>>
implements AuthenticationBuilder<JwtAuthenticationToken> {
    protected final Converter<Jwt, Collection<GrantedAuthority>> authoritiesConverter;
    protected final JwtBuilder<?> jwt;

    @Autowired
    public JwtAuthenticationTokenBuilder(JwtBuilder<?> jwtBuilder, Converter<Jwt, Collection<GrantedAuthority>> authoritiesConverter) {
        this.authoritiesConverter = authoritiesConverter;
        this.jwt = jwtBuilder;
    }

    @Autowired
    public JwtAuthenticationTokenBuilder(Converter<Jwt, Collection<GrantedAuthority>> authoritiesConverter) {
        this(new JwtBuilder(), authoritiesConverter);
    }

    public T token(Consumer<JwtBuilder<?>> jwtBuilderConsumer) {
        jwtBuilderConsumer.accept(this.jwt);
        return this.downcast();
    }

    public T name(String name) {
        this.jwt.subject(name);
        return this.downcast();
    }

    public T claim(String name, Object value) {
        this.jwt.claim(name, value);
        return this.downcast();
    }

    public T scopes(String ... scopes) {
        this.jwt.claim("scope", scopes.length == 0 ? null : Stream.of(scopes).collect(Collectors.joining(" ")));
        return this.downcast();
    }

    public T subject(String subject) {
        this.jwt.subject(subject);
        return this.downcast();
    }

    @Override
    public JwtAuthenticationToken build() {
        Jwt token = this.jwt.build();
        return new JwtAuthenticationToken(token, (Collection)this.authoritiesConverter.convert((Object)token));
    }

    protected T downcast() {
        return (T)this;
    }

    protected Collection<GrantedAuthority> getAuthorities(Jwt token) {
        return (Collection)this.authoritiesConverter.convert((Object)token);
    }
}

