/*
 * Decompiled with CFR 0.152.
 */
package com.c4_soft.springaddons.test.security.support.missingpublicapi;

import com.c4_soft.springaddons.test.security.support.AuthenticationBuilder;
import com.c4_soft.springaddons.test.security.support.missingpublicapi.OAuth2IntrospectionToken;
import java.util.Collection;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.springframework.core.convert.converter.Converter;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.oauth2.core.DefaultOAuth2AuthenticatedPrincipal;
import org.springframework.security.oauth2.core.OAuth2AccessToken;
import org.springframework.security.oauth2.core.OAuth2AuthenticatedPrincipal;
import org.springframework.security.oauth2.server.resource.authentication.BearerTokenAuthentication;

public class BearerTokenAuthenticationBuilder<T extends BearerTokenAuthenticationBuilder<T>>
implements AuthenticationBuilder<BearerTokenAuthentication> {
    protected final Converter<Map<String, Object>, Collection<GrantedAuthority>> authoritiesConverter;
    protected final OAuth2IntrospectionToken.OAuth2IntrospectionTokenBuilder<?> tokenBuilder;
    private static final String SCOPE_AUTHORITIES_PREFIX = "SCOPE_";
    private static final Converter<Map<String, Object>, Collection<GrantedAuthority>> SCOPE_AUTHORITIES_CONVERTER = claims -> BearerTokenAuthenticationBuilder.extractScopes(claims).map(s -> new SimpleGrantedAuthority(SCOPE_AUTHORITIES_PREFIX + s)).collect(Collectors.toSet());

    public BearerTokenAuthenticationBuilder(Converter<Map<String, Object>, Collection<GrantedAuthority>> authoritiesConverter, OAuth2IntrospectionToken.OAuth2IntrospectionTokenBuilder<?> tokenBuilder) {
        this.authoritiesConverter = authoritiesConverter;
        this.tokenBuilder = tokenBuilder;
    }

    public BearerTokenAuthenticationBuilder() {
        this(SCOPE_AUTHORITIES_CONVERTER, new OAuth2IntrospectionToken.OAuth2IntrospectionTokenBuilder());
    }

    public T name(String subject) {
        this.tokenBuilder.attributes(claims -> claims.subject(subject).username(subject));
        return this.downcast();
    }

    public T attribute(String name, Object value) {
        this.tokenBuilder.attributes(claims -> claims.claim(name, value));
        return this.downcast();
    }

    public T token(Consumer<OAuth2IntrospectionToken.OAuth2IntrospectionTokenBuilder<?>> tokenBuilderConsumer) {
        tokenBuilderConsumer.accept(this.tokenBuilder);
        return this.downcast();
    }

    @Override
    public BearerTokenAuthentication build() {
        OAuth2IntrospectionToken token = this.tokenBuilder.build();
        OAuth2AccessToken accessToken = new OAuth2AccessToken(OAuth2AccessToken.TokenType.BEARER, token.getTokenValue(), token.getAttributes().getIssuedAt(), token.getAttributes().getExpiresAt(), token.getAttributes().getScope());
        return new BearerTokenAuthentication((OAuth2AuthenticatedPrincipal)new DefaultOAuth2AuthenticatedPrincipal((Map)token.getAttributes(), (Collection)this.authoritiesConverter.convert((Object)token.getAttributes())), accessToken, (Collection)this.authoritiesConverter.convert((Object)token.getAttributes()));
    }

    protected T downcast() {
        return (T)this;
    }

    private static Stream<String> extractScopes(Map<String, Object> claims) {
        Object scopeClaim = claims.containsKey("scope") ? claims.get("scope") : claims.get("scp");
        return scopeClaim == null ? Stream.empty() : Stream.of(scopeClaim.toString().split(" "));
    }
}

