/*
 * Decompiled with CFR 0.152.
 */
package com.c4_soft.springaddons.test.security.support;

import com.c4_soft.oauth2.UnmodifiableClaimSet;
import com.c4_soft.springaddons.security.oauth2.server.resource.authentication.OAuth2ClaimSetAuthentication;
import com.c4_soft.springaddons.test.security.support.AuthoritiesConverterNotAMockException;
import com.c4_soft.springaddons.test.security.support.Defaults;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.springframework.core.convert.converter.Converter;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;

public class ClaimSetAuthenticationTestingBuilder<C extends UnmodifiableClaimSet, T extends ClaimSetAuthenticationTestingBuilder<C, T>> {
    protected final Map<String, Object> claims = new HashMap<String, Object>();
    private final Converter<Map<String, Object>, Set<GrantedAuthority>> authoritiesConverter;
    private final Converter<Map<String, Object>, C> claimsExtractor;

    public ClaimSetAuthenticationTestingBuilder(Converter<Map<String, Object>, Set<GrantedAuthority>> authoritiesConverter, Converter<Map<String, Object>, C> claimsExtractor) {
        this.authoritiesConverter = authoritiesConverter;
        this.claimsExtractor = claimsExtractor;
        this.authorities(Defaults.AUTHORITIES);
    }

    public T claims(Consumer<? extends Map<String, Object>> claimsConsumer) {
        claimsConsumer.accept(this.claims);
        return this.downcast();
    }

    public T authorities(Stream<String> authorities) {
        Set grantedAuthorities = authorities.map(SimpleGrantedAuthority::new).collect(Collectors.toSet());
        try {
            Mockito.when((Object)((Set)this.authoritiesConverter.convert((Object)((Map)ArgumentMatchers.any())))).thenReturn(grantedAuthorities);
        }
        catch (RuntimeException e) {
            throw new AuthoritiesConverterNotAMockException();
        }
        return this.downcast();
    }

    public T authorities(String ... authorities) {
        return this.authorities(Stream.of(authorities));
    }

    public OAuth2ClaimSetAuthentication<C> build() {
        return new OAuth2ClaimSetAuthentication((UnmodifiableClaimSet)this.claimsExtractor.convert(this.claims), this.authoritiesConverter);
    }

    protected T downcast() {
        return (T)this;
    }
}

