/*
 * Decompiled with CFR 0.152.
 */
package com.c4_soft.springaddons.test.security.context.support;

import com.c4_soft.oauth2.rfc7662.IntrospectionClaimNames;
import com.c4_soft.oauth2.rfc7662.IntrospectionClaimSet;
import com.c4_soft.springaddons.test.security.context.support.AbstractWithClaimSetFactory;
import com.c4_soft.springaddons.test.security.context.support.StringAttribute;
import com.c4_soft.springaddons.test.security.context.support.StringAttributeParserSupport;
import com.c4_soft.springaddons.test.security.support.introspection.IntrospectionClaimSetAuthenticationTestingBuilder;
import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Inherited;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.Map;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.AliasFor;
import org.springframework.core.convert.converter.Converter;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.test.context.support.TestExecutionEvent;
import org.springframework.security.test.context.support.WithSecurityContext;
import org.springframework.util.StringUtils;

@Target(value={ElementType.METHOD, ElementType.TYPE})
@Retention(value=RetentionPolicy.RUNTIME)
@Inherited
@Documented
@WithSecurityContext(factory=Factory.class)
public @interface WithMockIntrospectionClaimSet {
    @AliasFor(value="authorities")
    public String[] value() default {};

    @AliasFor(value="value")
    public String[] authorities() default {};

    @AliasFor(value="username")
    public String name() default "";

    @AliasFor(value="name")
    public String username() default "";

    public String subject() default "";

    public StringAttribute[] claims() default {};

    @AliasFor(annotation=WithSecurityContext.class)
    public TestExecutionEvent setupBefore() default TestExecutionEvent.TEST_METHOD;

    public static final class Factory
    extends AbstractWithClaimSetFactory<WithMockIntrospectionClaimSet, IntrospectionClaimSet> {
        private final StringAttributeParserSupport parsingSupport = new StringAttributeParserSupport();

        @Autowired
        public Factory(Converter<Map<String, Object>, Set<GrantedAuthority>> authoritiesConverter) {
            super(authoritiesConverter, new IntrospectionClaimSetAuthenticationTestingBuilder(authoritiesConverter, claimsMap -> new IntrospectionClaimSet(claimsMap)));
        }

        @Override
        protected String[] authoritiesOverride(WithMockIntrospectionClaimSet annotation) {
            return annotation.authorities();
        }

        @Override
        protected Map<String, Object> claimsMap(WithMockIntrospectionClaimSet annotation) {
            IntrospectionClaimSet.Builder claimsBuilder = IntrospectionClaimSet.builder();
            this.parsingSupport.parse(annotation.claims()).forEach((arg_0, arg_1) -> ((IntrospectionClaimSet.Builder)claimsBuilder).claim(arg_0, arg_1));
            if (StringUtils.hasLength((String)annotation.subject())) {
                claimsBuilder.subject(annotation.subject());
            }
            if (StringUtils.hasLength((String)annotation.username())) {
                claimsBuilder.username(annotation.username());
            }
            if (!claimsBuilder.containsKey((Object)IntrospectionClaimNames.USERNAME.value)) {
                claimsBuilder.username("user");
            }
            return claimsBuilder;
        }
    }
}

