/*
 * Decompiled with CFR 0.152.
 */
package com.c4_soft.springaddons.test.security.context.support;

import com.c4_soft.oauth2.UnmodifiableClaimSet;
import com.c4_soft.springaddons.security.oauth2.server.resource.authentication.OAuth2ClaimSetAuthentication;
import com.c4_soft.springaddons.test.security.support.ClaimSetAuthenticationTestingBuilder;
import com.c4_soft.springaddons.test.security.support.Defaults;
import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.springframework.core.convert.converter.Converter;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.test.context.support.WithSecurityContextFactory;

public abstract class AbstractWithClaimSetFactory<A extends Annotation, C extends UnmodifiableClaimSet>
implements WithSecurityContextFactory<A> {
    private final Converter<Map<String, Object>, Set<GrantedAuthority>> authoritiesConverter;
    private final ClaimSetAuthenticationTestingBuilder<C, ?> authBuilder;

    public AbstractWithClaimSetFactory(Converter<Map<String, Object>, Set<GrantedAuthority>> authoritiesConverter, ClaimSetAuthenticationTestingBuilder<C, ?> authBuilder) {
        this.authoritiesConverter = authoritiesConverter;
        this.authBuilder = authBuilder;
    }

    public SecurityContext createSecurityContext(A annotation) {
        SecurityContext context = SecurityContextHolder.createEmptyContext();
        context.setAuthentication(this.authentication(annotation));
        return context;
    }

    protected OAuth2ClaimSetAuthentication<C> authentication(A annotation) {
        this.authBuilder.claims(claims -> claims.putAll(this.claimsMap(annotation)));
        String[] overridenAuthorities = this.authoritiesOverride(annotation);
        if (overridenAuthorities.length > 0) {
            this.authBuilder.authorities(overridenAuthorities);
        } else if (this.authoritiesConverter.getClass().getName().contains("Mockito")) {
            this.authBuilder.authorities(Defaults.AUTHORITIES);
        }
        return this.authBuilder.build();
    }

    protected Map<String, Object> claimsMap(A annotation) {
        return new HashMap<String, Object>();
    }

    protected String[] authoritiesOverride(A annotation) {
        return new String[0];
    }
}

