/*
 * Decompiled with CFR 0.152.
 */
package com.c4_soft.springaddons.security.oauth2.server.resource.authentication;

import com.c4_soft.oauth2.rfc7519.JwtClaimSet;
import com.c4_soft.springaddons.security.oauth2.server.resource.authentication.AbstractClaimSetAuthenticationManager;
import java.util.Map;
import java.util.Set;
import org.springframework.core.convert.converter.Converter;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.oauth2.jwt.Jwt;
import org.springframework.security.oauth2.jwt.JwtDecoder;
import org.springframework.security.oauth2.server.resource.BearerTokenAuthenticationToken;

public class JwtClaimSetAuthenticationManager<T extends JwtClaimSet>
extends AbstractClaimSetAuthenticationManager<T> {
    private final JwtDecoder jwtDecoder;
    private final Converter<Map<String, Object>, T> typedClaimsExtractor;

    public JwtClaimSetAuthenticationManager(JwtDecoder jwtDecoder, Converter<Map<String, Object>, T> typedClaimsExtractor, Converter<Map<String, Object>, Set<GrantedAuthority>> authoritiesConverter) {
        super(authoritiesConverter);
        this.jwtDecoder = jwtDecoder;
        this.typedClaimsExtractor = typedClaimsExtractor;
    }

    @Override
    protected T extractClaims(BearerTokenAuthenticationToken bearer) {
        Jwt jwt = this.jwtDecoder.decode(bearer.getToken());
        return (T)((JwtClaimSet)this.typedClaimsExtractor.convert((Object)jwt.getClaims()));
    }
}

