/*
 * Decompiled with CFR 0.152.
 */
package com.c4_soft.springaddons.security.oidc.starter.synchronised.client;

import com.c4_soft.springaddons.security.oidc.starter.properties.SpringAddonsOidcProperties;
import com.c4_soft.springaddons.security.oidc.starter.properties.condition.HasTokenEdpointParametersPropertiesCondition;
import com.c4_soft.springaddons.security.oidc.starter.properties.condition.bean.DefaultGrantedAuthoritiesMapperCondition;
import com.c4_soft.springaddons.security.oidc.starter.properties.condition.bean.DefaultOAuth2AuthorizedClientManagerCondition;
import com.c4_soft.springaddons.security.oidc.starter.properties.condition.bean.DefaultOAuth2AuthorizedClientProviderCondition;
import com.c4_soft.springaddons.security.oidc.starter.properties.condition.configuration.IsServletOauth2ClientCondition;
import com.c4_soft.springaddons.security.oidc.starter.synchronised.client.PerRegistrationOAuth2AuthorizedClientProvider;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.core.convert.converter.Converter;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.mapping.GrantedAuthoritiesMapper;
import org.springframework.security.oauth2.client.OAuth2AuthorizedClientManager;
import org.springframework.security.oauth2.client.OAuth2AuthorizedClientProvider;
import org.springframework.security.oauth2.client.registration.ClientRegistrationRepository;
import org.springframework.security.oauth2.client.registration.InMemoryClientRegistrationRepository;
import org.springframework.security.oauth2.client.web.DefaultOAuth2AuthorizedClientManager;
import org.springframework.security.oauth2.client.web.OAuth2AuthorizedClientRepository;
import org.springframework.security.oauth2.core.oidc.user.OidcUserAuthority;
import org.springframework.security.oauth2.core.user.OAuth2UserAuthority;

@Conditional(value={IsServletOauth2ClientCondition.class, HasTokenEdpointParametersPropertiesCondition.class})
@AutoConfiguration
public class SpringAddonsOAuth2AuthorizedClientBeans {
    @Conditional(value={DefaultOAuth2AuthorizedClientManagerCondition.class})
    @Bean
    OAuth2AuthorizedClientManager authorizedClientManager(ClientRegistrationRepository clientRegistrationRepository, OAuth2AuthorizedClientRepository authorizedClientRepository, OAuth2AuthorizedClientProvider oauth2AuthorizedClientProvider) {
        DefaultOAuth2AuthorizedClientManager authorizedClientManager = new DefaultOAuth2AuthorizedClientManager(clientRegistrationRepository, authorizedClientRepository);
        authorizedClientManager.setAuthorizedClientProvider(oauth2AuthorizedClientProvider);
        return authorizedClientManager;
    }

    @Conditional(value={DefaultOAuth2AuthorizedClientProviderCondition.class})
    @Bean
    OAuth2AuthorizedClientProvider oauth2AuthorizedClientProvider(SpringAddonsOidcProperties addonsProperties, InMemoryClientRegistrationRepository clientRegistrationRepository) {
        return new PerRegistrationOAuth2AuthorizedClientProvider(clientRegistrationRepository, addonsProperties, Map.of());
    }

    @Conditional(value={DefaultGrantedAuthoritiesMapperCondition.class})
    @Bean
    GrantedAuthoritiesMapper grantedAuthoritiesMapper(Converter<Map<String, Object>, Collection<? extends GrantedAuthority>> authoritiesConverter) {
        return authorities -> {
            HashSet mappedAuthorities = new HashSet();
            authorities.forEach(authority -> {
                if (authority instanceof OidcUserAuthority) {
                    OidcUserAuthority oidcAuth = (OidcUserAuthority)authority;
                    mappedAuthorities.addAll((Collection)authoritiesConverter.convert((Object)oidcAuth.getIdToken().getClaims()));
                } else if (authority instanceof OAuth2UserAuthority) {
                    OAuth2UserAuthority oauth2Auth = (OAuth2UserAuthority)authority;
                    mappedAuthorities.addAll((Collection)authoritiesConverter.convert((Object)oauth2Auth.getAttributes()));
                }
            });
            return mappedAuthorities;
        };
    }
}

