/*
 * Decompiled with CFR 0.152.
 */
package com.c4_soft.springaddons.security.oidc.starter.reactive;

import java.util.NoSuchElementException;
import org.springframework.http.HttpStatus;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.server.WebSession;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class ServerHttpRequestSupport {
    public static Mono<ServerHttpRequest> getRequest() {
        return Mono.deferContextual(Mono::just).map(contextView -> ((ServerWebExchange)contextView.get(ServerWebExchange.class)).getRequest());
    }

    public static Mono<WebSession> getSession() {
        return Mono.deferContextual(Mono::just).flatMap(contextView -> ((ServerWebExchange)contextView.get(ServerWebExchange.class)).getSession());
    }

    public static Mono<String> getUniqueHeader(String headerName) throws MissingHeaderException, MultiValuedHeaderException {
        try {
            return ServerHttpRequestSupport.getNonEmptyHeaderValues(headerName).single();
        }
        catch (NoSuchElementException e) {
            throw new MissingHeaderException(headerName);
        }
        catch (IndexOutOfBoundsException e) {
            throw new MultiValuedHeaderException(headerName);
        }
    }

    public static Flux<String> getNonEmptyHeaderValues(String headerName) {
        return ServerHttpRequestSupport.getRequest().flatMapMany(req -> Flux.fromStream(req.getHeaders().getOrEmpty((Object)headerName).stream().filter(StringUtils::hasLength)));
    }

    @ResponseStatus(code=HttpStatus.UNAUTHORIZED)
    public static class MissingHeaderException
    extends RuntimeException {
        private static final long serialVersionUID = -4894061353773464761L;

        public MissingHeaderException(String headerName) {
            super(headerName + " is missing");
            assert (StringUtils.hasText((String)headerName));
        }
    }

    @ResponseStatus(code=HttpStatus.UNAUTHORIZED)
    public static class MultiValuedHeaderException
    extends RuntimeException {
        private static final long serialVersionUID = 1654993007508549674L;

        public MultiValuedHeaderException(String headerName) {
            super(headerName + " is not unique");
            assert (StringUtils.hasText((String)headerName));
        }
    }

    @ResponseStatus(code=HttpStatus.UNAUTHORIZED)
    public static class InvalidHeaderException
    extends RuntimeException {
        private static final long serialVersionUID = -6233252290377524340L;

        public InvalidHeaderException(String headerName) {
            super(headerName + " is not valid");
            assert (StringUtils.hasText((String)headerName));
        }
    }
}

