/*
 * Decompiled with CFR 0.152.
 */
package com.c4_soft.springaddons.security.oidc.starter.synchronised.client;

import com.c4_soft.springaddons.security.oidc.starter.LogoutRequestUriBuilder;
import com.c4_soft.springaddons.security.oidc.starter.SpringAddonsOAuth2LogoutRequestUriBuilder;
import com.c4_soft.springaddons.security.oidc.starter.properties.SpringAddonsOidcProperties;
import com.c4_soft.springaddons.security.oidc.starter.properties.condition.bean.DefaultAuthenticationFailureHandlerCondition;
import com.c4_soft.springaddons.security.oidc.starter.properties.condition.bean.DefaultAuthenticationSuccessHandlerCondition;
import com.c4_soft.springaddons.security.oidc.starter.properties.condition.configuration.IsClientWithLoginCondition;
import com.c4_soft.springaddons.security.oidc.starter.synchronised.ServletConfigurationSupport;
import com.c4_soft.springaddons.security.oidc.starter.synchronised.SpringAddonsOidcBeans;
import com.c4_soft.springaddons.security.oidc.starter.synchronised.client.ClientExpressionInterceptUrlRegistryPostProcessor;
import com.c4_soft.springaddons.security.oidc.starter.synchronised.client.ClientSynchronizedHttpSecurityPostProcessor;
import com.c4_soft.springaddons.security.oidc.starter.synchronised.client.PreAuthorizationCodeRedirectStrategy;
import com.c4_soft.springaddons.security.oidc.starter.synchronised.client.SpringAddonsLogoutSuccessHandler;
import com.c4_soft.springaddons.security.oidc.starter.synchronised.client.SpringAddonsOAuth2AuthorizationRequestResolver;
import com.c4_soft.springaddons.security.oidc.starter.synchronised.client.SpringAddonsOauth2AuthenticationFailureHandler;
import com.c4_soft.springaddons.security.oidc.starter.synchronised.client.SpringAddonsOauth2AuthenticationSuccessHandler;
import com.c4_soft.springaddons.security.oidc.starter.synchronised.client.SpringAddonsOauth2RedirectStrategy;
import java.util.Optional;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.ImportAutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.autoconfigure.security.oauth2.client.OAuth2ClientProperties;
import org.springframework.boot.autoconfigure.web.ServerProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.core.annotation.Order;
import org.springframework.http.HttpStatus;
import org.springframework.security.config.Customizer;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.config.annotation.web.configurers.AuthorizeHttpRequestsConfigurer;
import org.springframework.security.config.annotation.web.configurers.oauth2.client.OAuth2LoginConfigurer;
import org.springframework.security.config.annotation.web.configurers.oauth2.client.OidcLogoutConfigurer;
import org.springframework.security.oauth2.client.registration.ClientRegistrationRepository;
import org.springframework.security.oauth2.client.web.OAuth2AuthorizationRequestResolver;
import org.springframework.security.web.RedirectStrategy;
import org.springframework.security.web.SecurityFilterChain;
import org.springframework.security.web.authentication.AuthenticationFailureHandler;
import org.springframework.security.web.authentication.AuthenticationSuccessHandler;
import org.springframework.security.web.authentication.logout.LogoutSuccessHandler;

@ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.SERVLET)
@Conditional(value={IsClientWithLoginCondition.class})
@EnableWebSecurity
@AutoConfiguration
@ImportAutoConfiguration(value={SpringAddonsOidcBeans.class})
public class SpringAddonsOidcClientWithLoginBeans {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SpringAddonsOidcClientWithLoginBeans.class);

    @Order(value=0x7FFFFFFE)
    @Bean
    SecurityFilterChain springAddonsClientFilterChain(HttpSecurity http, ServerProperties serverProperties, PreAuthorizationCodeRedirectStrategy preAuthorizationCodeRedirectStrategy, OAuth2AuthorizationRequestResolver authorizationRequestResolver, Optional<AuthenticationSuccessHandler> authenticationSuccessHandler, Optional<AuthenticationFailureHandler> authenticationFailureHandler, LogoutSuccessHandler logoutSuccessHandler, SpringAddonsOidcProperties addonsProperties, ClientExpressionInterceptUrlRegistryPostProcessor authorizePostProcessor, ClientSynchronizedHttpSecurityPostProcessor httpPostProcessor, Customizer<OidcLogoutConfigurer<HttpSecurity>> oidcLogoutCustomizer) throws Exception {
        log.info("Applying client OAuth2 configuration for: {}", addonsProperties.getClient().getSecurityMatchers());
        http.securityMatcher(addonsProperties.getClient().getSecurityMatchers().toArray(new String[0]));
        http.oauth2Login(login -> {
            login.authorizationEndpoint(authorizationEndpoint -> {
                authorizationEndpoint.authorizationRedirectStrategy((RedirectStrategy)preAuthorizationCodeRedirectStrategy);
                authorizationEndpoint.authorizationRequestResolver(authorizationRequestResolver);
            });
            addonsProperties.getClient().getLoginPath().ifPresent(arg_0 -> ((OAuth2LoginConfigurer)login).loginPage(arg_0));
            authenticationSuccessHandler.ifPresent(arg_0 -> ((OAuth2LoginConfigurer)login).successHandler(arg_0));
            authenticationFailureHandler.ifPresent(arg_0 -> ((OAuth2LoginConfigurer)login).failureHandler(arg_0));
        });
        http.logout(logout -> logout.logoutSuccessHandler(logoutSuccessHandler));
        if (addonsProperties.getClient().getBackChannelLogout().isEnabled()) {
            http.oidcLogout(oidcLogoutCustomizer);
        }
        ServletConfigurationSupport.configureClient(http, serverProperties, addonsProperties.getClient(), authorizePostProcessor, httpPostProcessor);
        return (SecurityFilterChain)http.build();
    }

    @ConditionalOnMissingBean
    @Bean
    OAuth2AuthorizationRequestResolver oAuth2AuthorizationRequestResolver(OAuth2ClientProperties bootClientProperties, ClientRegistrationRepository clientRegistrationRepository, SpringAddonsOidcProperties addonsProperties) {
        return new SpringAddonsOAuth2AuthorizationRequestResolver(bootClientProperties, clientRegistrationRepository, addonsProperties.getClient());
    }

    @ConditionalOnMissingBean
    @Bean
    LogoutRequestUriBuilder logoutRequestUriBuilder(SpringAddonsOidcProperties addonsProperties) {
        return new SpringAddonsOAuth2LogoutRequestUriBuilder(addonsProperties.getClient());
    }

    @ConditionalOnMissingBean
    @Bean
    LogoutSuccessHandler logoutSuccessHandler(LogoutRequestUriBuilder logoutRequestUriBuilder, ClientRegistrationRepository clientRegistrationRepository, SpringAddonsOidcProperties addonsProperties) {
        return new SpringAddonsLogoutSuccessHandler(logoutRequestUriBuilder, clientRegistrationRepository, addonsProperties);
    }

    @ConditionalOnMissingBean
    @Bean
    ClientExpressionInterceptUrlRegistryPostProcessor clientAuthorizePostProcessor() {
        return registry -> ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)registry.anyRequest()).authenticated();
    }

    @ConditionalOnMissingBean
    @Bean
    ClientSynchronizedHttpSecurityPostProcessor clientHttpPostProcessor() {
        return http -> http;
    }

    @ConditionalOnMissingBean
    @Bean
    PreAuthorizationCodeRedirectStrategy authorizationCodeRedirectStrategy(SpringAddonsOidcProperties addonsProperties) {
        return new SpringAddonsPreAuthorizationCodeRedirectStrategy(addonsProperties.getClient().getOauth2Redirections().getPreAuthorizationCode());
    }

    @Conditional(value={DefaultAuthenticationSuccessHandlerCondition.class})
    @Bean
    AuthenticationSuccessHandler authenticationSuccessHandler(SpringAddonsOidcProperties addonsProperties) {
        return new SpringAddonsOauth2AuthenticationSuccessHandler(addonsProperties);
    }

    @Conditional(value={DefaultAuthenticationFailureHandlerCondition.class})
    @Bean
    AuthenticationFailureHandler authenticationFailureHandler(SpringAddonsOidcProperties addonsProperties) {
        return new SpringAddonsOauth2AuthenticationFailureHandler(addonsProperties);
    }

    @ConditionalOnMissingBean
    @Bean
    Customizer<OidcLogoutConfigurer<HttpSecurity>> oidcLogoutCustomizer() {
        return Customizer.withDefaults();
    }

    public static class SpringAddonsPreAuthorizationCodeRedirectStrategy
    extends SpringAddonsOauth2RedirectStrategy
    implements PreAuthorizationCodeRedirectStrategy {
        public SpringAddonsPreAuthorizationCodeRedirectStrategy(HttpStatus defaultStatus) {
            super(defaultStatus);
        }
    }
}

