/*
 * Decompiled with CFR 0.152.
 */
package com.c4_soft.springaddons.security.oauth2.config;

import com.c4_soft.springaddons.security.oauth2.config.MissingAuthorizationServerConfigurationException;
import com.c4_soft.springaddons.security.oauth2.config.OAuth2AuthoritiesConverter;
import com.c4_soft.springaddons.security.oauth2.config.SpringAddonsSecurityProperties;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import lombok.Generated;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;

public class ConfigurableClaimSet2AuthoritiesConverter
implements OAuth2AuthoritiesConverter {
    private final SpringAddonsSecurityProperties properties;

    public Collection<? extends GrantedAuthority> convert(Map<String, Object> source) {
        SpringAddonsSecurityProperties.SimpleAuthoritiesMappingProperties authoritiesMappingProperties = this.getAuthoritiesMappingProperties(source);
        return Stream.of(authoritiesMappingProperties.getClaims()).flatMap(rolesPath -> ConfigurableClaimSet2AuthoritiesConverter.getRoles(source, rolesPath)).map(r -> String.format("%s%s", authoritiesMappingProperties.getPrefix(), this.processCase((String)r, authoritiesMappingProperties.getCaze()))).map(r -> new SimpleGrantedAuthority(r)).toList();
    }

    private String processCase(String role, SpringAddonsSecurityProperties.Case caze) {
        switch (caze) {
            case UPPER: {
                return role.toUpperCase();
            }
            case LOWER: {
                return role.toLowerCase();
            }
        }
        return role;
    }

    private SpringAddonsSecurityProperties.SimpleAuthoritiesMappingProperties getAuthoritiesMappingProperties(Map<String, Object> claimSet) {
        return Stream.of(this.properties.getIssuers()).filter(ap -> Objects.equals(ap.getLocation().toString(), claimSet.get("iss").toString())).findAny().orElseThrow(() -> new MissingAuthorizationServerConfigurationException(Optional.ofNullable(claimSet.get("iss")).map(Object::toString).orElse(null))).getAuthorities();
    }

    private static Stream<String> getRoles(Map<String, Object> claims, String rolesPath) {
        String[] claimsToWalk = rolesPath.split("\\.");
        int i = 0;
        Optional<Map<String, Object>> obj = Optional.of(claims);
        while (i++ < claimsToWalk.length) {
            String claimName = claimsToWalk[i - 1];
            if (i == claimsToWalk.length) {
                return obj.map(o -> (List)o.get(claimName)).orElse(List.of()).stream().map(Object::toString);
            }
            obj = obj.map(o -> (Map)o.get(claimName));
        }
        return Stream.empty();
    }

    @Generated
    public ConfigurableClaimSet2AuthoritiesConverter(SpringAddonsSecurityProperties properties) {
        this.properties = properties;
    }
}

