/*
 * Decompiled with CFR 0.152.
 */
package com.byteslounge.cdi.resolver.verifier;

import com.byteslounge.cdi.annotation.PropertyBundle;
import com.byteslounge.cdi.annotation.PropertyKey;
import com.byteslounge.cdi.annotation.PropertyLocale;
import com.byteslounge.cdi.exception.ExtensionInitializationException;
import com.byteslounge.cdi.resolver.verifier.ResolverMethodVerifier;
import java.lang.annotation.Annotation;
import javax.enterprise.inject.spi.AnnotatedMethod;
import javax.enterprise.inject.spi.AnnotatedParameter;

public class PropertyResolverMethodParametersVerifier
implements ResolverMethodVerifier {
    private final AnnotatedMethod<?> propertyResolverMethod;

    public PropertyResolverMethodParametersVerifier(AnnotatedMethod<?> propertyResolverMethod) {
        this.propertyResolverMethod = propertyResolverMethod;
    }

    @Override
    public void verify() {
        this.checkPropertyKeyExists();
        this.checkRepeatedParameterType(PropertyKey.class);
        this.checkRepeatedParameterType(PropertyLocale.class);
        this.checkRepeatedParameterType(PropertyBundle.class);
        this.checkMultipleAnnotationParameter();
    }

    private void checkPropertyKeyExists() {
        boolean foundKeyProperty = false;
        for (AnnotatedParameter parameter : this.propertyResolverMethod.getParameters()) {
            if (!parameter.isAnnotationPresent(PropertyKey.class)) continue;
            foundKeyProperty = true;
            break;
        }
        if (!foundKeyProperty) {
            throw new ExtensionInitializationException("At least one parameter of the custom property resolver must represent de property key, annotated with " + PropertyKey.class.getName());
        }
    }

    private void checkRepeatedParameterType(Class<? extends Annotation> annotation) {
        int count = 0;
        for (AnnotatedParameter parameter : this.propertyResolverMethod.getParameters()) {
            if (!parameter.isAnnotationPresent(annotation)) continue;
            ++count;
        }
        if (count > 1) {
            throw new ExtensionInitializationException("There must be only a single param annotated with " + annotation.getSimpleName() + " in the property resolver method");
        }
    }

    private void checkMultipleAnnotationParameter() {
        for (AnnotatedParameter parameter : this.propertyResolverMethod.getParameters()) {
            int count = 0;
            if (parameter.isAnnotationPresent(PropertyKey.class)) {
                ++count;
            }
            if (parameter.isAnnotationPresent(PropertyBundle.class)) {
                ++count;
            }
            if (parameter.isAnnotationPresent(PropertyLocale.class)) {
                ++count;
            }
            if (count <= 1) continue;
            throw new ExtensionInitializationException("A property resolver method parameter must not be annotated with more than one of the following: " + PropertyKey.class.getSimpleName() + ", " + PropertyBundle.class.getSimpleName() + " or " + PropertyLocale.class.getSimpleName());
        }
    }
}

