/*
 * Decompiled with CFR 0.152.
 */
package com.byteslounge.cdi.resolver.verifier;

import com.byteslounge.cdi.annotation.PropertyLocale;
import com.byteslounge.cdi.exception.ExtensionInitializationException;
import com.byteslounge.cdi.resolver.verifier.ResolverMethodVerifier;
import javax.enterprise.inject.spi.AnnotatedMethod;
import javax.enterprise.inject.spi.AnnotatedParameter;

public class LocaleResolverMethodParametersVerifier
implements ResolverMethodVerifier {
    private final AnnotatedMethod<?> localeResolverMethod;

    public LocaleResolverMethodParametersVerifier(AnnotatedMethod<?> localeResolverMethod) {
        this.localeResolverMethod = localeResolverMethod;
    }

    @Override
    public void verify() {
        this.checkLocaleResolverParameterAnnotations();
    }

    private void checkLocaleResolverParameterAnnotations() {
        for (AnnotatedParameter parameter : this.localeResolverMethod.getParameters()) {
            if (!parameter.isAnnotationPresent(PropertyLocale.class)) continue;
            throw new ExtensionInitializationException("A Locale resolver method parameter must not be annotated with: " + PropertyLocale.class.getSimpleName());
        }
    }
}

