/*
 * Decompiled with CFR 0.152.
 */
package com.byteslounge.cdi.resolver.verifier;

import com.byteslounge.cdi.annotation.Property;
import com.byteslounge.cdi.exception.ExtensionInitializationException;
import com.byteslounge.cdi.resolver.verifier.ResolverMethodVerifier;
import com.byteslounge.cdi.utils.MessageUtils;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.context.RequestScoped;
import javax.enterprise.context.SessionScoped;
import javax.enterprise.inject.spi.AnnotatedMethod;
import javax.enterprise.inject.spi.AnnotatedParameter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DependentResolverMethodParametersVerifier
implements ResolverMethodVerifier {
    private final AnnotatedMethod<?> resolverMethod;
    private static final Logger logger = LoggerFactory.getLogger(DependentResolverMethodParametersVerifier.class);

    public DependentResolverMethodParametersVerifier(AnnotatedMethod<?> resolverMethod) {
        this.resolverMethod = resolverMethod;
    }

    @Override
    public void verify() {
        for (AnnotatedParameter parameter : this.resolverMethod.getParameters()) {
            if (!this.checkDependentScope((Class)parameter.getBaseType())) continue;
            this.checkPropertyField((Class)parameter.getBaseType(), (Class)parameter.getBaseType());
        }
    }

    private boolean checkDependentScope(Class<?> type) {
        for (Annotation annotation : type.getAnnotations()) {
            Class<?> viewScopedClass;
            block4: {
                if (annotation.annotationType().equals(SessionScoped.class) || annotation.annotationType().equals(RequestScoped.class) || annotation.annotationType().equals(ApplicationScoped.class)) {
                    return false;
                }
                viewScopedClass = null;
                try {
                    viewScopedClass = Class.forName("javax.faces.view.ViewScoped");
                }
                catch (Exception e) {
                    if (!logger.isDebugEnabled()) break block4;
                    logger.debug("Class javax.faces.view.ViewScoped was not found: Running in a Java EE 6 environment.");
                }
            }
            if (viewScopedClass == null || !annotation.annotationType().equals(viewScopedClass)) continue;
            return false;
        }
        return true;
    }

    private void checkPropertyField(Class<?> originalType, Class<?> type) {
        for (Field field : type.getDeclaredFields()) {
            for (Annotation annotation : field.getAnnotations()) {
                if (!annotation.annotationType().equals(Property.class)) continue;
                throw new ExtensionInitializationException("Resolver method " + MessageUtils.getMethodDefinition(this.resolverMethod) + " is injecting a Dependent scoped bean which in turn also has an injected @" + Property.class.getSimpleName() + " (this would cause a stack overflow because Dependent scoped bean instances are injected directly and not proxied). Type: " + originalType.getSimpleName() + ", field: " + field.getName());
            }
        }
        if (type.getSuperclass() != null && !type.getSuperclass().equals(Object.class)) {
            this.checkPropertyField(originalType, type.getSuperclass());
        }
    }
}

