/*
 * Decompiled with CFR 0.152.
 */
package com.byteslounge.cdi.resolver.bean;

import com.byteslounge.cdi.exception.ExtensionInitializationException;
import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResolverInstanceLazyInitializer {
    private static final Logger logger = LoggerFactory.getLogger(ResolverInstanceLazyInitializer.class);
    private volatile ResolverInstance resolverInstance;
    private final Class<?> resolverClass;
    private final BeanManagerList beanManagers;

    public ResolverInstanceLazyInitializer(BeanManager beanManager, Class<?> resolverClass) {
        this.beanManagers = new BeanManagerList(beanManager);
        this.resolverClass = resolverClass;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResolverInstance get() {
        ResolverInstance result = this.resolverInstance;
        if (result == null) {
            ResolverInstanceLazyInitializer resolverInstanceLazyInitializer = this;
            synchronized (resolverInstanceLazyInitializer) {
                result = this.resolverInstance;
                if (result == null) {
                    BeanResolverResult beanResolverResult = CDIBeanResolver.resolve(this.beanManagers, this.resolverClass);
                    BeanManager activeBeanManager = beanResolverResult.activeBeanManager;
                    Bean resolverBean = activeBeanManager.resolve(beanResolverResult.beans);
                    if (resolverBean == null) {
                        throw new ExtensionInitializationException("Could not resolve bean for class: " + this.resolverClass.getName() + ". The class is probably deployed in a module that is not accessible by the CDI Properties extension classloader." + " Try to deploy the resolver class in a library JAR instead.");
                    }
                    CreationalContext creationalContext = activeBeanManager.createCreationalContext((Contextual)resolverBean);
                    this.resolverInstance = result = new ResolverInstance(activeBeanManager.getReference(resolverBean, this.resolverClass, creationalContext), resolverBean, activeBeanManager);
                }
            }
        }
        return result;
    }

    private static class BeanManagerList
    implements Iterable<BeanManager> {
        private final BeanManager[] providedBeanManagers;

        BeanManagerList(BeanManager ... providedBeanManagers) {
            this.providedBeanManagers = providedBeanManagers;
        }

        @Override
        public Iterator<BeanManager> iterator() {
            return new BeanManagerIterator();
        }

        private class BeanManagerIterator
        implements Iterator<BeanManager> {
            private static final String BEAN_MANAGER_JNDI = "java:comp/BeanManager";
            private int currentIndex = 0;
            private BeanManager jndiBeanManager;

            BeanManagerIterator() {
                try {
                    this.jndiBeanManager = (BeanManager)new InitialContext().lookup(BEAN_MANAGER_JNDI);
                }
                catch (NamingException e) {
                    logger.warn("Could not fetch Bean Manager from JNDI. Fallback strategy will not be used.", (Throwable)e);
                }
            }

            @Override
            public boolean hasNext() {
                return this.currentIndex < BeanManagerList.this.providedBeanManagers.length || this.jndiBeanManager != null;
            }

            @Override
            public BeanManager next() {
                if (this.currentIndex < BeanManagerList.this.providedBeanManagers.length) {
                    return BeanManagerList.this.providedBeanManagers[this.currentIndex++];
                }
                if (this.jndiBeanManager == null) {
                    throw new NoSuchElementException();
                }
                BeanManager result = this.jndiBeanManager;
                this.jndiBeanManager = null;
                return result;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Not implemented");
            }
        }
    }

    static class BeanResolverResult {
        private final Set<Bean<?>> beans;
        private final BeanManager activeBeanManager;

        public BeanResolverResult(Set<Bean<?>> beans, BeanManager activeBeanManager) {
            this.beans = beans;
            this.activeBeanManager = activeBeanManager;
        }
    }

    static class CDIBeanResolver {
        CDIBeanResolver() {
        }

        static BeanResolverResult resolve(Iterable<BeanManager> beanManagers, Class<?> beanClass) {
            Set beans = Collections.emptySet();
            Iterator<BeanManager> it = beanManagers.iterator();
            BeanManager activeBeanManager = null;
            while (it.hasNext() && (beans = (activeBeanManager = it.next()).getBeans(beanClass, new Annotation[0])).isEmpty()) {
            }
            return new BeanResolverResult(beans, activeBeanManager);
        }
    }

    public static class ResolverInstance {
        private final Object resolverInstance;
        private final Bean<?> resolverBean;
        private final BeanManager activeBeanManager;

        public ResolverInstance(Object resolverInstance, Bean<?> resolverBean, BeanManager activeBeanManager) {
            this.resolverInstance = resolverInstance;
            this.resolverBean = resolverBean;
            this.activeBeanManager = activeBeanManager;
        }

        public Object getResolverInstance() {
            return this.resolverInstance;
        }

        public Bean<?> getResolverBean() {
            return this.resolverBean;
        }

        public BeanManager getActiveBeanManager() {
            return this.activeBeanManager;
        }
    }
}

