/*
 * Decompiled with CFR 0.152.
 */
package com.byteslounge.cdi.resolver.bean;

import com.byteslounge.cdi.resolver.bean.ResolverBean;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.BeanManager;

public class ResolverGateway {
    private final Map<Class<? extends ResolverBean<?>>, ResolverBean<?>> resolverBeanMap = new ConcurrentHashMap();

    public ResolverGateway(ResolverBean<?> ... resolvers) {
        for (ResolverBean<?> resolver : resolvers) {
            this.resolverBeanMap.put(resolver.getClass(), resolver);
        }
    }

    public void process(AnnotatedType<?> at) {
        for (ResolverBean<?> resolverBean : this.resolverBeanMap.values()) {
            resolverBean.process(at);
        }
    }

    public void intializeResolvers(BeanManager beanManager) {
        for (ResolverBean<?> resolverBean : this.resolverBeanMap.values()) {
            resolverBean.initialize(beanManager);
        }
    }

    public <T extends ResolverBean<?>> T getResolver(Class<T> klass) {
        return (T)this.resolverBeanMap.get(klass);
    }
}

