/*
 * Decompiled with CFR 0.152.
 */
package com.byteslounge.cdi.resolver.bean;

import com.byteslounge.cdi.exception.ExtensionInitializationException;
import com.byteslounge.cdi.extension.param.InjectableResolverParameter;
import com.byteslounge.cdi.extension.param.ResolverParameter;
import com.byteslounge.cdi.resolver.bean.ResolverBean;
import com.byteslounge.cdi.resolver.bean.ResolverInstanceLazyInitializer;
import com.byteslounge.cdi.resolver.context.ResolverContext;
import com.byteslounge.cdi.resolver.extractor.BundleResolverParameterExtractor;
import com.byteslounge.cdi.resolver.extractor.KeyResolverParameterExtractor;
import com.byteslounge.cdi.resolver.extractor.LocaleResolverParameterExtractor;
import com.byteslounge.cdi.resolver.extractor.ResolverParameterExtractor;
import com.byteslounge.cdi.utils.MessageUtils;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.AnnotatedMethod;
import javax.enterprise.inject.spi.AnnotatedParameter;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.BeanManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractResolverBean<T>
implements ResolverBean<T> {
    private static final Logger logger = LoggerFactory.getLogger(AbstractResolverBean.class);
    private final Class<? extends Annotation> typeToSearch;
    private final Class<?> defaulResolverClass;
    private final String resolverDescription;
    private AnnotatedMethod<?> providedResolverMethod = null;
    private List<ResolverParameter<?>> resolverParameters;
    private ResolverBean<Locale> localeResolverBean;
    protected AnnotatedMethod<?> resolverMethod = null;
    private ResolverInstanceLazyInitializer lazyInitializer;

    public AbstractResolverBean(Class<? extends Annotation> typeToSearch, String resolverDescription, Class<?> defaulResolverClass) {
        this.typeToSearch = typeToSearch;
        this.resolverDescription = resolverDescription;
        this.defaulResolverClass = defaulResolverClass;
    }

    abstract void validate(AnnotatedMethod<?> var1);

    @Override
    public void process(AnnotatedType<?> at) {
        for (AnnotatedMethod method : at.getMethods()) {
            if (!method.isAnnotationPresent(this.typeToSearch)) continue;
            if (method.getJavaMember().getDeclaringClass().equals(this.defaulResolverClass)) {
                this.resolverMethod = method;
                if (!logger.isDebugEnabled()) continue;
                logger.debug("Found default " + this.resolverDescription + "resolver method: " + MessageUtils.getMethodDefinition(method));
                continue;
            }
            if (this.providedResolverMethod != null) {
                String errorMessage = "Found multiple provided " + this.resolverDescription + " resolver methods: " + MessageUtils.getMethodDefinition(this.providedResolverMethod) + ", " + MessageUtils.getMethodDefinition(method);
                logger.error(errorMessage);
                throw new ExtensionInitializationException(errorMessage);
            }
            this.providedResolverMethod = method;
            if (!logger.isDebugEnabled()) continue;
            logger.debug("Found provided " + this.resolverDescription + "resolver method: " + MessageUtils.getMethodDefinition(this.providedResolverMethod));
        }
    }

    @Override
    public void initialize(BeanManager beanManager) {
        this.validate();
        this.lazyInitializer = new ResolverInstanceLazyInitializer(beanManager, this.resolverMethod.getJavaMember().getDeclaringClass());
        this.resolverParameters = new ArrayList();
        List<ResolverParameterExtractor> extractors = Arrays.asList(new KeyResolverParameterExtractor(), new LocaleResolverParameterExtractor(this.localeResolverBean), new BundleResolverParameterExtractor(), new ResolverParameterExtractor<InjectableResolverParameter>(){

            @Override
            public InjectableResolverParameter extract(AnnotatedParameter<?> parameter) {
                return new InjectableResolverParameter(parameter);
            }
        });
        block0: for (AnnotatedParameter parameter : this.resolverMethod.getParameters()) {
            for (ResolverParameterExtractor extractor : extractors) {
                Object resolverParameter = extractor.extract(parameter);
                if (resolverParameter == null) continue;
                this.resolverParameters.add((ResolverParameter<?>)resolverParameter);
                continue block0;
            }
        }
        logger.info("Configured " + this.resolverDescription + " resolver method: " + MessageUtils.getMethodDefinition(this.resolverMethod));
    }

    @Override
    public T invoke(ResolverContext resolverContext, CreationalContext<?> ctx) {
        ResolverInstanceLazyInitializer.ResolverInstance resolverInstance = this.lazyInitializer.get();
        resolverContext.setResolverBean(resolverInstance.getResolverBean());
        resolverContext.setBeanManager(resolverInstance.getActiveBeanManager());
        ArrayList parameters = new ArrayList();
        if (logger.isDebugEnabled()) {
            logger.debug("About to resolve parameters of " + this.resolverDescription + " resolver method");
        }
        for (ResolverParameter<?> parameter : this.resolverParameters) {
            parameters.add(parameter.resolve(resolverContext, ctx));
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Parameters resolved. Invoking " + this.resolverDescription + " resolver method.");
        }
        try {
            return (T)this.resolverMethod.getJavaMember().invoke(resolverInstance.getResolverInstance(), parameters.toArray());
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            throw new RuntimeException("Could not invoke resolver", e);
        }
    }

    private void validate() {
        if (this.providedResolverMethod != null) {
            this.resolverMethod = this.providedResolverMethod;
        }
        if (this.resolverMethod == null) {
            String errorMessage = "Could not find any " + this.resolverDescription + " resolver method.";
            logger.error(errorMessage);
            throw new ExtensionInitializationException(errorMessage);
        }
        this.validate(this.resolverMethod);
    }

    public void setLocaleResolverBean(ResolverBean<Locale> localeResolverBean) {
        this.localeResolverBean = localeResolverBean;
    }
}

