/*
 * Decompiled with CFR 0.152.
 */
package com.byteslounge.cdi.resolver;

import com.byteslounge.cdi.annotation.PropertyBundle;
import com.byteslounge.cdi.annotation.PropertyKey;
import com.byteslounge.cdi.annotation.PropertyLocale;
import com.byteslounge.cdi.annotation.PropertyResolver;
import java.io.Serializable;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.enterprise.context.ApplicationScoped;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class DefaultPropertyResolverMethod
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = LoggerFactory.getLogger(DefaultPropertyResolverMethod.class);

    @PropertyResolver
    public String resolveProperty(@PropertyLocale Locale locale, @PropertyBundle String bundleName, @PropertyKey String key) {
        ResourceBundle bundle;
        String value;
        if (logger.isDebugEnabled()) {
            logger.debug("Resolving property. Locale " + locale.toString() + ", bundle: " + bundleName + ", key: " + key);
        }
        if ((value = (bundle = ResourceBundle.getBundle(bundleName, locale)).getString(key)) != null) {
            if (logger.isDebugEnabled()) {
                logger.debug("Property [" + key + "] resolved to: " + value);
            }
            return value;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Could not resolve property: " + key);
        }
        return key;
    }
}

