/*
 * Decompiled with CFR 0.152.
 */
package com.byteslounge.cdi.extension.param;

import com.byteslounge.cdi.extension.param.ResolverParameter;
import com.byteslounge.cdi.resolver.context.ResolverContext;
import java.lang.annotation.Annotation;
import java.lang.reflect.Member;
import java.lang.reflect.Type;
import java.util.HashSet;
import java.util.Set;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.Annotated;
import javax.enterprise.inject.spi.AnnotatedParameter;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.InjectionPoint;

public class InjectableResolverParameter
implements InjectionPoint,
ResolverParameter<Object> {
    private final AnnotatedParameter<?> parameter;
    private BeanManager beanManager;
    private Bean<?> resolverBean;

    public InjectableResolverParameter(AnnotatedParameter<?> parameter) {
        this.parameter = parameter;
    }

    public Annotated getAnnotated() {
        return this.parameter;
    }

    public Bean<?> getBean() {
        return this.resolverBean;
    }

    public Member getMember() {
        return this.parameter.getDeclaringCallable().getJavaMember();
    }

    public Set<Annotation> getQualifiers() {
        HashSet<Annotation> qualifiers = new HashSet<Annotation>();
        for (Annotation annotation : this.parameter.getAnnotations()) {
            if (!this.beanManager.isQualifier(annotation.annotationType())) continue;
            qualifiers.add(annotation);
        }
        return qualifiers;
    }

    public Type getType() {
        return this.parameter.getBaseType();
    }

    public boolean isDelegate() {
        return false;
    }

    public boolean isTransient() {
        return false;
    }

    @Override
    public <T> Object resolve(ResolverContext resolverContext, CreationalContext<T> ctx) {
        this.resolverBean = resolverContext.getResolverBean();
        this.beanManager = resolverContext.getBeanManager();
        return this.beanManager.getInjectableReference((InjectionPoint)this, ctx);
    }
}

