/*
 * Decompiled with CFR 0.152.
 */
package com.byteslounge.cdi.extension;

import com.byteslounge.cdi.annotation.Property;
import com.byteslounge.cdi.configuration.ExtensionConfiguration;
import com.byteslounge.cdi.converter.PropertyConverter;
import com.byteslounge.cdi.converter.PropertyConverterFactory;
import com.byteslounge.cdi.exception.PropertyResolverException;
import com.byteslounge.cdi.format.PropertyFormat;
import com.byteslounge.cdi.resolver.bean.PropertyResolverBean;
import com.byteslounge.cdi.resolver.context.ResolverContext;
import java.lang.reflect.Field;
import java.util.Set;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.enterprise.inject.spi.InjectionTarget;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertyResolverInjectionTarget<T>
implements InjectionTarget<T> {
    private final InjectionTarget<T> injectionTarget;
    private final AnnotatedType<T> annotatedType;
    private final PropertyResolverBean propertyResolverBean;
    private final PropertyFormat propertyFormat;
    private static final Logger logger = LoggerFactory.getLogger(PropertyResolverInjectionTarget.class);

    public PropertyResolverInjectionTarget(InjectionTarget<T> injectionTarget, AnnotatedType<T> annotatedType, PropertyResolverBean propertyResolverBean, PropertyFormat propertyFormat) {
        this.injectionTarget = injectionTarget;
        this.annotatedType = annotatedType;
        this.propertyResolverBean = propertyResolverBean;
        this.propertyFormat = propertyFormat;
    }

    public void dispose(T instance) {
        this.injectionTarget.dispose(instance);
    }

    public Set<InjectionPoint> getInjectionPoints() {
        return this.injectionTarget.getInjectionPoints();
    }

    public T produce(CreationalContext<T> ctx) {
        return (T)this.injectionTarget.produce(ctx);
    }

    public void inject(T instance, CreationalContext<T> ctx) {
        this.injectionTarget.inject(instance, ctx);
        for (Field field : this.annotatedType.getJavaClass().getDeclaredFields()) {
            String bundleName;
            Property annotation = field.getAnnotation(Property.class);
            if (annotation == null) continue;
            String key = annotation.value();
            String string = bundleName = annotation.resourceBundleBaseName().length() > 0 ? annotation.resourceBundleBaseName() : ExtensionConfiguration.INSTANCE.getResourceBundleDefaultBaseName();
            if (bundleName == null) {
                String errorMessage = "Property bundle name must have a configured default value (see github project instructions) or it must be configured in @" + Property.class.getSimpleName() + " annotation.";
                logger.error(errorMessage);
                throw new PropertyResolverException(errorMessage);
            }
            field.setAccessible(true);
            String value = (String)this.propertyResolverBean.invoke(ResolverContext.create(key, bundleName), ctx);
            if (logger.isDebugEnabled()) {
                logger.debug("Resolved property with key " + key + " to " + value);
            }
            if (annotation.parameters().length > 0) {
                if (field.getType().equals(String.class)) {
                    value = this.propertyFormat.formatMessage(value, annotation.parameters());
                } else {
                    logger.warn("Found property with defined parameters for formatting but property type is not of type " + String.class.getSimpleName() + ". Skipping message format... [" + field.getDeclaringClass().getSimpleName() + "." + field.getName() + "]");
                }
            }
            PropertyConverter<?> propertyConverter = PropertyConverterFactory.getConverter(field.getType());
            String convertedValue = null;
            if (propertyConverter != null) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Converting property using converter " + propertyConverter.getClass().getSimpleName());
                }
                convertedValue = (String)propertyConverter.convert(value);
            }
            if (logger.isDebugEnabled()) {
                logger.debug("Applying property value " + value + " to field " + field.getDeclaringClass().getSimpleName() + "." + field.getName());
            }
            try {
                field.set(instance, convertedValue != null ? convertedValue : value);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException("Could not set property in managed bean field", e);
            }
        }
    }

    public void postConstruct(T instance) {
        this.injectionTarget.postConstruct(instance);
    }

    public void preDestroy(T instance) {
        this.injectionTarget.preDestroy(instance);
    }
}

