/*
 * Decompiled with CFR 0.152.
 */
package com.byteslounge.cdi.extension;

import com.byteslounge.cdi.configuration.ExtensionConfiguration;
import com.byteslounge.cdi.extension.PropertyResolverInjectionTarget;
import com.byteslounge.cdi.format.PropertyFormat;
import com.byteslounge.cdi.format.PropertyFormatFactory;
import com.byteslounge.cdi.resolver.bean.LocaleResolverBean;
import com.byteslounge.cdi.resolver.bean.PropertyResolverBean;
import com.byteslounge.cdi.resolver.bean.ResolverGateway;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.spi.AfterDeploymentValidation;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.Extension;
import javax.enterprise.inject.spi.InjectionTarget;
import javax.enterprise.inject.spi.ProcessAnnotatedType;
import javax.enterprise.inject.spi.ProcessInjectionTarget;

public class PropertyExtension
implements Extension {
    private final ResolverGateway resolverGateway = new ResolverGateway(new PropertyResolverBean(), new LocaleResolverBean());

    void processAnnotatedType(@Observes ProcessAnnotatedType<?> pat) {
        this.resolverGateway.process(pat.getAnnotatedType());
    }

    void afterDeploymentValidation(@Observes AfterDeploymentValidation adv, BeanManager beanManager) {
        PropertyResolverBean propertyResolverBean = this.resolverGateway.getResolver(PropertyResolverBean.class);
        LocaleResolverBean localeResolverBean = this.resolverGateway.getResolver(LocaleResolverBean.class);
        propertyResolverBean.setLocaleResolverBean(localeResolverBean);
        this.resolverGateway.intializeResolvers(beanManager);
        ExtensionConfiguration.INSTANCE.init();
    }

    <T> void processInjectionTarget(@Observes ProcessInjectionTarget<T> pit, BeanManager beanManager) {
        InjectionTarget it = pit.getInjectionTarget();
        AnnotatedType at = pit.getAnnotatedType();
        PropertyFormat propertyFormat = PropertyFormatFactory.getInstance();
        pit.setInjectionTarget(new PropertyResolverInjectionTarget(it, at, this.resolverGateway.getResolver(PropertyResolverBean.class), propertyFormat));
    }
}

