/*
 * Decompiled with CFR 0.152.
 */
package com.byteslounge.cdi.configuration;

import com.byteslounge.cdi.configuration.ExtensionConfiguration;
import com.byteslounge.cdi.resolver.locale.JSFLocaleResolver;
import com.byteslounge.cdi.resolver.locale.LocaleResolverFactory;
import java.util.Set;
import javax.servlet.ServletContainerInitializer;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExtensionInitializer
implements ServletContainerInitializer {
    public static final String DEFAULT_RESOURCE_BUNDLE_BASE_NAME_PARAM = "defaultResourceBundleBaseName";
    private static final Logger logger = LoggerFactory.getLogger(ExtensionInitializer.class);

    public void onStartup(Set<Class<?>> c, ServletContext context) throws ServletException {
        ExtensionConfiguration.INSTANCE.init();
        String defaultResourceBundleBaseName = context.getInitParameter(DEFAULT_RESOURCE_BUNDLE_BASE_NAME_PARAM);
        if (defaultResourceBundleBaseName != null) {
            logger.info("Found a default resource bundle name in web application context parameters. Will set it as: " + defaultResourceBundleBaseName);
            ExtensionConfiguration.INSTANCE.setResourceBundleDefaultBaseName(defaultResourceBundleBaseName);
        }
        try {
            Class.forName("javax.faces.context.FacesContext");
            LocaleResolverFactory.setLocaleResolver(new JSFLocaleResolver());
        }
        catch (ClassNotFoundException e) {
            logger.info("FacesContext not present in the application's classpath");
        }
    }
}

