/*
 * Decompiled with CFR 0.152.
 */
package com.byteslounge.cdi.configuration;

import com.byteslounge.cdi.exception.ExtensionInitializationException;
import com.byteslounge.cdi.resolver.locale.LocaleResolverFactory;
import com.byteslounge.cdi.resolver.locale.StandaloneLocaleResolver;
import java.io.IOException;
import java.net.URL;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum ExtensionConfiguration {
    INSTANCE;

    private static final String EXTENSION_PROPERTIES_FILE = "CDIProperties.properties";
    private Logger logger = LoggerFactory.getLogger(ExtensionConfiguration.class);
    private String resourceBundleDefaultBaseName;

    private ExtensionConfiguration() {
        LocaleResolverFactory.setLocaleResolver(new StandaloneLocaleResolver());
        URL url = ExtensionConfiguration.class.getClassLoader().getResource(EXTENSION_PROPERTIES_FILE);
        if (url != null) {
            Properties properties = new Properties();
            try {
                properties.load(url.openStream());
                this.setResourceBundleDefaultBaseName(properties.getProperty("defaultResourceBundleBaseName"));
            }
            catch (IOException e) {
                throw new ExtensionInitializationException("Error while loading CDI Properties configuration file", e);
            }
        }
    }

    public void init() {
    }

    public String getResourceBundleDefaultBaseName() {
        return this.resourceBundleDefaultBaseName;
    }

    public void setResourceBundleDefaultBaseName(String resourceBundleDefaultBaseName) {
        this.resourceBundleDefaultBaseName = resourceBundleDefaultBaseName;
        this.logger.info("Default resource bundle name was set as: " + this.resourceBundleDefaultBaseName);
    }
}

