/*
 * Decompiled with CFR 0.152.
 */
package io.crossbar.autobahn.websocket;

import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.util.Base64;
import android.util.Log;
import io.crossbar.autobahn.websocket.exceptions.WebSocketException;
import io.crossbar.autobahn.websocket.messages.BinaryMessage;
import io.crossbar.autobahn.websocket.messages.ClientHandshake;
import io.crossbar.autobahn.websocket.messages.Close;
import io.crossbar.autobahn.websocket.messages.ConnectionLost;
import io.crossbar.autobahn.websocket.messages.Error;
import io.crossbar.autobahn.websocket.messages.Ping;
import io.crossbar.autobahn.websocket.messages.Pong;
import io.crossbar.autobahn.websocket.messages.Quit;
import io.crossbar.autobahn.websocket.messages.RawTextMessage;
import io.crossbar.autobahn.websocket.messages.TextMessage;
import io.crossbar.autobahn.websocket.types.WebSocketOptions;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.net.Socket;
import java.net.SocketException;
import java.util.Random;

class WebSocketWriter
extends Handler {
    private static final boolean DEBUG = true;
    private static final String TAG = WebSocketWriter.class.getName();
    private static final String CRLF = "\r\n";
    private final Random mRng = new Random();
    private final Handler mMaster;
    private final Looper mLooper;
    private final WebSocketOptions mOptions;
    private BufferedOutputStream mBufferedOutputStream;
    private Socket mSocket;
    private boolean mActive;

    public WebSocketWriter(Looper looper, Handler master, Socket socket, WebSocketOptions options) throws IOException {
        super(looper);
        this.mLooper = looper;
        this.mMaster = master;
        this.mOptions = options;
        this.mSocket = socket;
        this.mBufferedOutputStream = new BufferedOutputStream(socket.getOutputStream(), options.getMaxFramePayloadSize() + 14);
        this.mActive = true;
        Log.d((String)TAG, (String)"created");
    }

    private void write(String stringToWrite) {
        try {
            this.mBufferedOutputStream.write(stringToWrite.getBytes("UTF-8"));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void write(byte byteToWrite) {
        try {
            this.mBufferedOutputStream.write(byteToWrite);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void write(byte[] bytesToWrite) {
        try {
            this.mBufferedOutputStream.write(bytesToWrite);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void forward(Object message) {
        if (!this.mActive) {
            Log.d((String)TAG, (String)"We have already quit, not processing further messages");
            return;
        }
        Message msg = this.obtainMessage();
        msg.obj = message;
        this.sendMessage(msg);
    }

    private void notify(Object message) {
        Message msg = this.mMaster.obtainMessage();
        msg.obj = message;
        this.mMaster.sendMessage(msg);
    }

    private String newHandshakeKey() {
        byte[] ba = new byte[16];
        this.mRng.nextBytes(ba);
        return Base64.encodeToString((byte[])ba, (int)2);
    }

    private byte[] newFrameMask() {
        byte[] ba = new byte[4];
        this.mRng.nextBytes(ba);
        return ba;
    }

    private void sendClientHandshake(ClientHandshake message) throws IOException {
        String path = message.mQuery != null ? message.mPath + "?" + message.mQuery : message.mPath;
        this.write("GET " + path + " HTTP/1.1");
        this.write(CRLF);
        this.write("Host: " + message.mHost);
        this.write(CRLF);
        this.write("Upgrade: WebSocket");
        this.write(CRLF);
        this.write("Connection: Upgrade");
        this.write(CRLF);
        this.write("Sec-WebSocket-Key: " + this.newHandshakeKey());
        this.write(CRLF);
        if (message.mOrigin != null && !message.mOrigin.equals("")) {
            this.write("Origin: " + message.mOrigin);
            this.write(CRLF);
        }
        if (message.mSubprotocols != null && message.mSubprotocols.length > 0) {
            this.write("Sec-WebSocket-Protocol: ");
            for (int i = 0; i < message.mSubprotocols.length; ++i) {
                this.write(message.mSubprotocols[i]);
                if (i == message.mSubprotocols.length - 1) continue;
                this.write(", ");
            }
            this.write(CRLF);
        }
        this.write("Sec-WebSocket-Version: 13");
        this.write(CRLF);
        if (message.mHeaderList != null) {
            for (String key : message.mHeaderList.keySet()) {
                this.write(key + ":" + message.mHeaderList.get(key));
                this.write(CRLF);
            }
        }
        this.write(CRLF);
    }

    private void sendClose(Close message) throws IOException, WebSocketException {
        if (message.mCode > 0) {
            byte[] payload;
            if (message.mReason != null && !message.mReason.equals("")) {
                byte[] pReason = message.mReason.getBytes("UTF-8");
                payload = new byte[2 + pReason.length];
                for (int i = 0; i < pReason.length; ++i) {
                    payload[i + 2] = pReason[i];
                }
            } else {
                payload = new byte[2];
            }
            if (payload != null && payload.length > 125) {
                throw new WebSocketException("close payload exceeds 125 octets");
            }
            payload[0] = (byte)(message.mCode >> 8 & 0xFF);
            payload[1] = (byte)(message.mCode & 0xFF);
            this.sendFrame(8, true, payload);
        } else {
            this.sendFrame(8, true, null);
        }
    }

    private void sendPing(Ping message) throws IOException, WebSocketException {
        if (message.mPayload != null && message.mPayload.length > 125) {
            throw new WebSocketException("ping payload exceeds 125 octets");
        }
        this.sendFrame(9, true, message.mPayload);
    }

    private void sendPong(Pong message) throws IOException, WebSocketException {
        if (message.mPayload != null && message.mPayload.length > 125) {
            throw new WebSocketException("pong payload exceeds 125 octets");
        }
        this.sendFrame(10, true, message.mPayload);
    }

    private void sendBinaryMessage(BinaryMessage message) throws IOException, WebSocketException {
        if (message.mPayload.length > this.mOptions.getMaxMessagePayloadSize()) {
            throw new WebSocketException("message payload exceeds payload limit");
        }
        this.sendFrame(2, true, message.mPayload);
    }

    private void sendTextMessage(TextMessage message) throws IOException, WebSocketException {
        byte[] payload = message.mPayload.getBytes("UTF-8");
        if (payload.length > this.mOptions.getMaxMessagePayloadSize()) {
            throw new WebSocketException("message payload exceeds payload limit");
        }
        this.sendFrame(1, true, payload);
    }

    private void sendRawTextMessage(RawTextMessage message) throws IOException, WebSocketException {
        if (message.mPayload.length > this.mOptions.getMaxMessagePayloadSize()) {
            throw new WebSocketException("message payload exceeds payload limit");
        }
        this.sendFrame(1, true, message.mPayload);
    }

    protected void sendFrame(int opcode, boolean fin, byte[] payload) throws IOException {
        if (payload != null) {
            this.sendFrame(opcode, fin, payload, 0, payload.length);
        } else {
            this.sendFrame(opcode, fin, null, 0, 0);
        }
    }

    protected void sendFrame(int opcode, boolean fin, byte[] payload, int offset, int length) throws IOException {
        long len;
        byte b0 = 0;
        if (fin) {
            b0 = (byte)(b0 | 0xFFFFFF80);
        }
        b0 = (byte)(b0 | (byte)opcode);
        this.write(b0);
        byte b1 = 0;
        if (this.mOptions.getMaskClientFrames()) {
            b1 = -128;
        }
        if ((len = (long)length) <= 125L) {
            b1 = (byte)(b1 | (byte)len);
            this.write(b1);
        } else if (len <= 65535L) {
            b1 = (byte)(b1 | 0x7E);
            this.write(b1);
            this.write(new byte[]{(byte)(len >> 8 & 0xFFL), (byte)(len & 0xFFL)});
        } else {
            b1 = (byte)(b1 | 0x7F);
            this.write(b1);
            this.write(new byte[]{(byte)(len >> 56 & 0xFFL), (byte)(len >> 48 & 0xFFL), (byte)(len >> 40 & 0xFFL), (byte)(len >> 32 & 0xFFL), (byte)(len >> 24 & 0xFFL), (byte)(len >> 16 & 0xFFL), (byte)(len >> 8 & 0xFFL), (byte)(len & 0xFFL)});
        }
        byte[] mask = null;
        if (this.mOptions.getMaskClientFrames()) {
            mask = this.newFrameMask();
            this.write(mask[0]);
            this.write(mask[1]);
            this.write(mask[2]);
            this.write(mask[3]);
        }
        if (len > 0L) {
            if (this.mOptions.getMaskClientFrames()) {
                int i = 0;
                while ((long)i < len) {
                    int n = i + offset;
                    payload[n] = (byte)(payload[n] ^ mask[i % 4]);
                    ++i;
                }
            }
            this.mBufferedOutputStream.write(payload, offset, length);
        }
    }

    public void handleMessage(Message msg) {
        try {
            this.processMessage(msg.obj);
            if (this.mActive && this.mSocket.isConnected() && !this.mSocket.isClosed()) {
                this.mBufferedOutputStream.flush();
            }
            if (msg.obj instanceof Close) {
                Close closeMessage = (Close)msg.obj;
                if (closeMessage.mIsReply) {
                    this.notify(new Close(closeMessage.mCode, closeMessage.mReason, true));
                }
            }
        }
        catch (SocketException e) {
            Log.d((String)TAG, (String)("run() : SocketException (" + e.toString() + ")"));
            this.notify(new ConnectionLost(null));
        }
        catch (Exception e) {
            e.printStackTrace();
            this.notify(new Error(e));
        }
    }

    protected void processMessage(Object msg) throws IOException, WebSocketException {
        if (msg instanceof TextMessage) {
            this.sendTextMessage((TextMessage)msg);
        } else if (msg instanceof RawTextMessage) {
            this.sendRawTextMessage((RawTextMessage)msg);
        } else if (msg instanceof BinaryMessage) {
            this.sendBinaryMessage((BinaryMessage)msg);
        } else if (msg instanceof Ping) {
            this.sendPing((Ping)msg);
        } else if (msg instanceof Pong) {
            this.sendPong((Pong)msg);
        } else if (msg instanceof Close) {
            this.sendClose((Close)msg);
        } else if (msg instanceof ClientHandshake) {
            this.sendClientHandshake((ClientHandshake)msg);
        } else if (msg instanceof Quit) {
            this.mLooper.quit();
            this.mActive = false;
            Log.d((String)TAG, (String)"ended");
        } else {
            this.processAppMessage(msg);
        }
    }

    protected void processAppMessage(Object msg) throws WebSocketException, IOException {
        throw new WebSocketException("unknown message received by WebSocketWriter");
    }
}

