/*
 * Decompiled with CFR 0.152.
 */
package com.byteowls.vaadin.chartjs.data;

import com.byteowls.vaadin.chartjs.data.Dataset;
import com.byteowls.vaadin.chartjs.utils.Pair;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public abstract class TimeDoubleDataset<T>
implements Dataset<T, Pair<LocalDateTime, Double>> {
    private static final long serialVersionUID = -6974707185168615990L;
    private List<Pair<LocalDateTime, Double>> data;

    public T data(Pair<LocalDateTime, Double> ... data) {
        this.data = Arrays.asList(data);
        return this.getThis();
    }

    @Override
    public T dataAsList(List<Pair<LocalDateTime, Double>> data) {
        this.data = data;
        return this.getThis();
    }

    @Override
    public List<Pair<LocalDateTime, Double>> getData() {
        return this.data;
    }

    public T addData(Pair<LocalDateTime, Double> data) {
        if (this.data == null) {
            this.data = new ArrayList<Pair<LocalDateTime, Double>>();
        }
        this.data.add(data);
        return this.getThis();
    }

    public T addData(LocalDateTime time, Double value) {
        this.addData(Pair.of(time, value));
        return this.getThis();
    }

    protected abstract T getThis();
}

