/*
 * Decompiled with CFR 0.152.
 */
package com.byteowls.vaadin.chartjs.options;

import com.byteowls.vaadin.chartjs.options.annotation.AbstractAnnotation;
import com.byteowls.vaadin.chartjs.options.annotation.BoxAnnotation;
import com.byteowls.vaadin.chartjs.options.annotation.DrawTime;
import com.byteowls.vaadin.chartjs.options.annotation.LineAnnotation;
import com.byteowls.vaadin.chartjs.utils.And;
import com.byteowls.vaadin.chartjs.utils.JUtils;
import com.byteowls.vaadin.chartjs.utils.JsonBuilder;
import elemental.json.Json;
import elemental.json.JsonObject;
import java.util.ArrayList;
import java.util.List;

public class AnnotationOptions<T>
extends And<T>
implements JsonBuilder {
    private static final long serialVersionUID = -4653427395957468095L;
    private DrawTime drawTime;
    private List<String> events;
    private Integer dblClickSpeed;
    private List<AbstractAnnotation> annotations;

    public AnnotationOptions(T parent) {
        super(parent);
    }

    public AnnotationOptions<T> drawTime(DrawTime drawTime) {
        this.drawTime = drawTime;
        return this;
    }

    public AnnotationOptions<T> dblClickSpeed(int dblClickSpeedMs) {
        this.dblClickSpeed = dblClickSpeedMs;
        return this;
    }

    public LineAnnotation<T> line() {
        if (this.annotations == null) {
            this.annotations = new ArrayList<AbstractAnnotation>();
        }
        LineAnnotation line = new LineAnnotation(this);
        this.annotations.add(line);
        return line;
    }

    public BoxAnnotation<T> box() {
        if (this.annotations == null) {
            this.annotations = new ArrayList<AbstractAnnotation>();
        }
        BoxAnnotation box = new BoxAnnotation(this);
        this.annotations.add(box);
        return box;
    }

    public void clearAnnotations() {
        this.annotations = null;
    }

    @Override
    public JsonObject buildJson() {
        JsonObject map = Json.createObject();
        if (this.drawTime != null) {
            JUtils.putNotNull(map, "drawTime", this.drawTime.name());
        }
        JUtils.putNotNullStringListOrSingle(map, "events", this.events);
        JUtils.putNotNull(map, "dblClickSpeed", this.dblClickSpeed);
        JUtils.putNotNullBuilders(map, "annotations", this.annotations);
        return map;
    }
}

