/*
 * Decompiled with CFR 0.152.
 */
package com.byteowls.vaadin.chartjs.data;

import com.byteowls.vaadin.chartjs.data.BubbleData;
import com.byteowls.vaadin.chartjs.data.Dataset;
import com.byteowls.vaadin.chartjs.utils.JUtils;
import elemental.json.Json;
import elemental.json.JsonObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class BubbleDataset
implements Dataset<BubbleDataset, BubbleData> {
    private static final long serialVersionUID = -1367482243614060700L;
    private String type;
    private List<BubbleData> data;
    private List<String> labels;
    private Map<String, BubbleData> dataMap;
    private Boolean hidden;
    private String label;
    private List<String> backgroundColor;
    private List<String> borderColor;
    private List<Integer> borderWidth;
    private List<String> hoverBackgroundColor;
    private List<String> hoverBorderColor;
    private List<Integer> hoverBorderWidth;
    private List<Integer> hoverRadius;

    public BubbleDataset type() {
        this.type = "bubble";
        return this;
    }

    public BubbleDataset addData(Double x, Double y, Double r) {
        if (this.data == null) {
            this.data = new ArrayList<BubbleData>();
        }
        this.data.add(new BubbleData().x(x).y(y).r(r));
        return this;
    }

    public BubbleDataset data(BubbleData ... data) {
        this.data = Arrays.asList(data);
        return this;
    }

    @Override
    public BubbleDataset dataAsList(List<BubbleData> data) {
        this.data = data;
        return this;
    }

    @Override
    public List<BubbleData> getData() {
        if (this.dataMap != null) {
            return new ArrayList<BubbleData>(this.dataMap.values());
        }
        return this.data;
    }

    @Override
    public BubbleDataset addLabeledData(String label, BubbleData data) {
        if (label != null && data != null) {
            if (this.labels == null) {
                this.labels = new ArrayList<String>();
            }
            if (!this.labels.contains(label)) {
                this.labels.add(label);
            }
            if (this.dataMap == null) {
                this.dataMap = new LinkedHashMap<String, BubbleData>();
            }
            this.dataMap.put(label, data);
        }
        return this;
    }

    @Override
    public List<String> getDataLabels() {
        return this.labels;
    }

    public BubbleDataset label(String label) {
        this.label = label;
        return this;
    }

    public BubbleDataset hidden(boolean hidden) {
        this.hidden = hidden;
        return this;
    }

    public BubbleDataset backgroundColor(String ... backgroundColor) {
        this.backgroundColor = Arrays.asList(backgroundColor);
        return this;
    }

    public BubbleDataset borderColor(String ... borderColor) {
        this.borderColor = Arrays.asList(borderColor);
        return this;
    }

    public BubbleDataset borderWidth(Integer ... borderWidth) {
        this.borderWidth = Arrays.asList(borderWidth);
        return this;
    }

    public BubbleDataset hoverBackgroundColor(String ... hoverBackgroundColor) {
        this.hoverBackgroundColor = Arrays.asList(hoverBackgroundColor);
        return this;
    }

    public BubbleDataset hoverBorderColor(String ... hoverBorderColor) {
        this.hoverBorderColor = Arrays.asList(hoverBorderColor);
        return this;
    }

    public BubbleDataset hoverBorderWidth(Integer ... hoverBorderWidth) {
        this.hoverBorderWidth = Arrays.asList(hoverBorderWidth);
        return this;
    }

    public BubbleDataset hoverRadius(Integer ... hoverRadius) {
        this.hoverRadius = Arrays.asList(hoverRadius);
        return this;
    }

    @Override
    public JsonObject buildJson() {
        JsonObject map = Json.createObject();
        JUtils.putNotNull(map, "type", this.type);
        JUtils.putNotNullBuilders(map, "data", this.data);
        JUtils.putNotNull(map, "label", this.label);
        JUtils.putNotNull(map, "hidden", this.hidden);
        JUtils.putNotNullStringListOrSingle(map, "backgroundColor", this.backgroundColor);
        JUtils.putNotNullStringListOrSingle(map, "borderColor", this.borderColor);
        JUtils.putNotNullIntListOrSingle(map, "borderWidth", this.borderWidth);
        JUtils.putNotNullStringListOrSingle(map, "hoverBackgroundColor", this.hoverBackgroundColor);
        JUtils.putNotNullStringListOrSingle(map, "hoverBorderColor", this.hoverBorderColor);
        JUtils.putNotNullIntListOrSingle(map, "hoverBorderWidth", this.hoverBorderWidth);
        JUtils.putNotNullIntListOrSingle(map, "hoverRadius", this.hoverRadius);
        return map;
    }
}

